using System;
using System.Collections.Generic;
using System.Text;
using SlothLib.Web.Search;
using System.Text.RegularExpressions;
using SlothLib.Web.Search.Google;

namespace SlothLib.Web.Search
{
    /// <summary>
    /// GoogleAPIgSNX
    /// </summary>
    public class GoogleSOAPSearchAPI : IWebSearch
    {
        
        #region privatetB[h

        // APIL[
        private string apiKey;

        // ΏۂƂ錾language restrict
        private string defaultLr;

        #endregion

        #region RXgN^

        /// <summary>
        /// RXgN^@Ώۂ̌w肷
        /// </summary>
        /// <param name="apiKey">NG</param>
        /// <param name="defaultLanguage">ΏۂƂ錾</param>
        public GoogleSOAPSearchAPI(string apiKey, Language defaultLanguage)
        {

            this.apiKey = apiKey;
            switch (defaultLanguage)
            {
                case Language.All:
                    this.defaultLr = string.Empty;
                    break;
                case Language.Japanese:
                    this.defaultLr = "lang_ja";
                    break;
                case Language.English:
                    this.defaultLr = "lang_en";
                    break;

            }
        }

        /// <summary>
        /// RXgN^@{̃y[WΏۂƂ
        /// </summary>
        /// <param name="apiKey">CZXL[</param>
        public GoogleSOAPSearchAPI(string apiKey)
            : this(apiKey, Language.Japanese)
        {
        }


        /// <summary>
        /// RXgN^@Ώۂׂ̌w肷
        /// </summary>
        /// <param name="apiKey">CZXL[</param>
        /// <param name="defaultLr">ΏۂƂ錾(lang_jǎ`œ͂Ă)</param>
        public GoogleSOAPSearchAPI(string apiKey, string defaultLr)
        {
            this.apiKey = apiKey;
            this.defaultLr = defaultLr;
        }


        #endregion

        #region DoSearch

        /// <summary>
        /// GoogleAPIpČs
        /// </summary>
        /// <param name="query">NG</param>
        /// <param name="maxResult">ʎ擾</param>
        /// <returns>GoogleSearchAPIResult^̌</returns>
        public GoogleSOAPSearchAPIResult DoSearch(string query, int maxResult)
        {
            return DoGoogleSearchAPI(query, maxResult, this.defaultLr);
        }

        #endregion

        # region DoGoogleSearchAPI

        /// <summary>
        /// s
        /// </summary>
        /// <param name="query">NG</param>
        /// <param name="maxResult">ő匋ʐ</param>
        /// <param name="lr">language restrict </param>
        /// <returns></returns>
        private GoogleSOAPSearchAPIResult DoGoogleSearchAPI(
            //string apiKey,
            string query,
            int maxResult,
            string lr
            //ȉ̈̑Ή́AԂƗ]T
            //bool filter,	yz
            //string restrict,yz
            //bool safeSearch,yz
            //string ie,yz
            //string oeyz
            )
        {
            // ʓp
            List<GoogleSOAPElement> ResultElementList = new List<GoogleSOAPElement>();

            // Create a Google Search object
            GoogleSearchService s = new GoogleSearchService();
            long totalResult = 0;
            // ʂ10ɕĎ擾
            for (int i = 0; i <= maxResult - 10; i = i + 10)
            {
                int range = maxResult - i;
                if (range > 10)
                {
                    range = 10;
                }

                GoogleSearchResult r = s.doGoogleSearch(apiKey, query,
                    i, range, false, "", false, lr, "", "");

                int rank = 0;
                foreach (ResultElement re in r.resultElements)
                {
                    rank++;
                    re.title = Regex.Replace(re.title, @"<[^>]*>", "");
                    re.snippet = Regex.Replace(re.snippet, @"<[^>]*>", "");

                    SlothLib.Web.Search.GoogleSOAPElement sere = new SlothLib.Web.Search.GoogleSOAPElement(
                        rank, re.URL, re.title, re.snippet);
                    ResultElementList.Add(sere);
                }
                totalResult = r.estimatedTotalResultsCount;
            }

            // Ԃʂ쐬Ă悤ȂB
            return new GoogleSOAPSearchAPIResult(query, totalResult, ResultElementList.ToArray());

        }

        #endregion

        #region OpenResultPage

        /// <summary>
        /// ʂuEUŕ\
        /// </summary>
        /// <param name="query">NG</param>
        /// <param name="language">ΏۂƂ錾</param>
        public static void OpenResultPage(string query, Language language)
        {
            string openURL = "http://www.google.co.jp/search?num=100&hl=ja&q=" + System.Web.HttpUtility.UrlEncode(query, System.Text.Encoding.UTF8);
            switch (language)
            {
                case Language.All:
                    break;
                case Language.English:
                    openURL += "&lr=lang_en";
                    break;
                case Language.Japanese:
                    openURL += "&lr=lang_ja";
                    break;
            }
            System.Diagnostics.Process.Start(openURL);
        }

        /// <summary>
        /// ʂuEUŕ\@{̃y[WΏۂƂ
        /// </summary>
        /// <param name="query">NG</param>
        public static void OpenResultPage(string query)
        {
            OpenResultPage(query, Language.Japanese);
        }

        #endregion

        #region 񋓌^

        /// <summary>
        /// ΏۂƂ錾
        /// </summary>
        public enum Language
        {


            /// <summary>
            /// { ftHg
            /// </summary>
            Japanese,

            /// <summary>
            /// p
            /// </summary>
            English,

            /// <summary>
            /// SĂ̌
            /// </summary>
            All,
        }

        #endregion

        #region IWebSearch o

        /// <summary>
        /// GoogleGWŌ
        /// </summary>
        /// <param name="query">NG</param>
        /// <param name="resultNum">擾</param>
        /// <returns></returns>
        IWebSearchResult IWebSearch.DoSearch(string query, int resultNum)
        {
            return DoSearch(query, resultNum);
        }

        #endregion

        #region ISearch o

        /// <summary>
        /// GoogleGWŌ
        /// </summary>
        /// <param name="query">NG</param>
        /// <param name="resultNum">擾</param>
        /// <returns></returns>
        ISearchResult ISearch.DoSearch(string query, int resultNum)
        {
            return DoSearch(query, resultNum);
        }

        #endregion
    }
}
