using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

namespace SlothLib.Web.Search
{
    /// <summary>
    /// YouTuběʗvfi[
    /// </summary>
    [Serializable]
    public class YouTubeElement : IVideoElement, ISerializable
    {
        #region RXgN^

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="author"></param>
        /// <param name="id"></param>
        /// <param name="title"></param>
        /// <param name="length_seconds"></param>
        /// <param name="rating_avg"></param>
        /// <param name="rating_count"></param>
        /// <param name="description"></param>
        /// <param name="view_count"></param>
        /// <param name="date"></param>
        /// <param name="comment_count"></param>
        /// <param name="tags"></param>
        /// <param name="uri"></param>
		/// <param name="thumbnail_url"></param>
		/// <param name="rank"></param>
		public YouTubeElement(string author, string id, string title, int length_seconds,
            double rating_avg, int rating_count, string description, int view_count, DateTime date, int comment_count,
            string tags, string uri, string thumbnail_url, int rank)
        {
            this.author = author; this.id = id; this.title = title; this.length_seconds = length_seconds;
            this.rating_avg = rating_avg; this.rating_count = rating_count; this.description = description;
            this.view_count = view_count; this.date = date; this.comment_count = comment_count; this.tags = tags;
            this.uri = uri; this.thumbnail_url = thumbnail_url;
            this.rank = rank;
        }

        #endregion

        #region privatetB[h

        string author;
        string id;
        string title;
        int length_seconds;
        double rating_avg;
        int rating_count;
        string description;
        int view_count;
        DateTime date;
        int comment_count;
        string tags;
        string uri;
        string thumbnail_url;
        int rank;

        #endregion

        #region vpeB

        /// <summary>
        /// rfĨ^Cg
        /// </summary>
        public string Title
        {
            get
            {
                return this.title;
            }
        }

        /// <summary>
        /// rfI̍
        /// </summary>
        public string Author
        {
            get
            {
                return this.author;
            }
        }

        /// <summary>
        /// rfIID
        /// </summary>
        public string ID
        {
            get
            {
                return this.id;
            }
        }

        /// <summary>
        /// rfI̐
        /// </summary>
        public string Description
        {
            get
            {
                return this.description;
            }
        }

        /// <summary>
        /// rfĨy[WURL
        /// </summary>
        public string URL
        {
            get
            {
                return this.uri;
            }
        }

        /// <summary>
        /// rfĨTlCURL
        /// </summary>
        public string ThumbnailURL
        {
            get
            {
                return this.thumbnail_url;
            }
        }

        /// <summary>
        /// rfIɂꂽ^O
        /// </summary>
        public string Tags
        {
            get
            {
                return this.tags;
            }
        }

        /// <summary>
        /// rfIɂꂽRg̐
        /// </summary>
        public int CommentCount
        {
            get
            {
                return this.comment_count;
            }
        }

        /// <summary>
        /// rfI̒ibj
        /// </summary>
        public int LengthSeconds
        {
            get
            {
                return this.length_seconds;
            }
        }

        /// <summary>
        /// ]ꂽ
        /// </summary>
        public int RatingCount
        {
            get
            {
                return this.rating_count;
            }
        }

        /// <summary>
        /// rfI{ꂽ
        /// </summary>
        public int ViewCount
        {
            get
            {
                return this.view_count;
            }
        }

        /// <summary>
        /// ]̕ϒl
        /// </summary>
        public double RatingAvg
        {
            get
            {
                return this.rating_avg;
            }
        }

        /// <summary>
        /// e
        /// </summary>
        public DateTime Date
        {
            get
            {
                return this.date;
            }
        }




        #endregion

        #region ISearchResultElement o

        string ISearchResultElement.URL
        {
            get
            {
                return this.uri;
            }
        }

        string ISearchResultElement.Title
        {
            get
            {
                return this.title;
            }
        }

        string ISearchResultElement.Description
        {
            get
            {
                return this.description;
            }
        }

        int ISearchResultElement.Rank
        {
            get
            {
                return this.rank;
            }
        }


        #endregion

        #region ToString()

        /// <summary>
        /// rfI\
        /// </summary>
        /// <returns></returns>
        public override string ToString()
        {
            return "Title:" + this.title + "\r\n"
                + "URL:" + this.uri + "\r\n"
            + "Author:" + this.author + "\r\n"
            + "CommentNum:" + this.comment_count.ToString() + "\r\n"
            + "Date:" + this.date + "\r\n"
            + "Description:" + this.description + "\r\n"
            + "id:" + this.id + "\r\n"
            + "length:" + this.length_seconds + "\r\n"
            + "rating_avg:" + this.rating_avg + "\r\n"
            + "rating_count:" + this.rating_count + "\r\n"
            + "tags:" + this.tags + "\r\n"
            + "thum url:" + this.thumbnail_url + "\r\n"
            + "view_Count:" + this.view_count;
        }

        #endregion

        #region IVideoElement o

        int IVideoElement.Duration
        {
            get
            {
                return this.length_seconds;
            }
        }

        string IVideoElement.ThumbnailURL
        {
            get
            {
                return this.thumbnail_url;
            }
        }

        #endregion

        #region ISerializable o

        /// <summary>
        /// VACYƂɌĂяo֐
        /// </summary>
        /// <param name="info">tVAɕKvȂׂẴf[^</param>
        /// <param name="context">VAXg[̓]Ɠ]</param>
        void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
        {
            info.AddValue("title", this.title);
            info.AddValue("url", this.uri);
            info.AddValue("author", this.author);
            info.AddValue("tags", this.tags);
            info.AddValue("id", this.id);
            info.AddValue("length_seconds", this.length_seconds);
            info.AddValue("rating_count", this.rating_count);
            info.AddValue("rating_avg", this.rating_avg);
            info.AddValue("thumbnail_url", this.thumbnail_url);
            info.AddValue("date", this.date);
            info.AddValue("description", this.description);
            info.AddValue("view_count", this.view_count);
            info.AddValue("comment_count", this.comment_count);
        }

        /// <summary>
        /// VACYꂽ̂fVACYꂽƂɌĂ΂RXgN^
        /// </summary>
        /// <param name="info">VAɕKvȂׂẴf[^</param>
        /// <param name="context">VAXg[̓]Ɠ]</param>
        protected YouTubeElement(SerializationInfo info, StreamingContext context)
        {
            this.title = info.GetString("title");
            this.uri = info.GetString("url");
            this.author = info.GetString("author");
            this.tags = info.GetString("tags");
            this.id = info.GetString("id");
            this.length_seconds = info.GetInt32("length_seconds");
            this.rating_avg = info.GetDouble("rating_avg");
            this.rating_count = info.GetInt32("rating_count");
            this.thumbnail_url = info.GetString("thumbnail_url");
            this.date = info.GetDateTime("date");
            this.description = info.GetString("description");
            this.view_count = info.GetInt32("view_count");
            this.comment_count = info.GetInt32("comment_count");
        }

        #endregion
    }
}
