//using System;
//using System.Collections.Generic;
//using System.Text;
//using SlothLib.Text;

package slothLib.io;
import slothLib.SlothLibException;
import slothLib.text.*;
	/**
	 * テキストファイルの内容を取得する
	 * 拡張子が何でも読もうとする
	 */
	public class TextReader extends AbstractContentReader
	{

		// 文字コード判別・変換器
		private IEncodingConverter encodingConverter;

		/**
		 * コンストラクタ
		 */
		public TextReader()
		{
			super(".txt");
			this.encodingConverter = new AutoDetectConverter();
		}

		/**
		 * コンストラクタ
		 * @param encodingConverter 文字コード判別・変換器
		 */
		public TextReader(IEncodingConverter encodingConverter)
		{
			super(".txt");
			this.encodingConverter = encodingConverter;
		}

		/**
		 * 引数で与えられた拡張子に対応しているかどうか
		 * @param extension ピリオド付きの拡張子
		 * @return 読み込み可能かどうか
		 */
		//public boolean isReadable(String extension)
//		{
			// 何も考えずにtrueを投げる。
			//return true;
//		}

		/**
		 * ファイルからテキストを抽出する。
		 * 対応しているかどうかはReadableを用いる。
		 * @param filePath ファイルのパス
		 * @return 抽出された内容
		 */
		protected  String process(String filePath)
		throws SlothLibException
		{
			EncodingConverterResult r = this.encodingConverter.convertTextFile(filePath);
			return r.getText();
		}

	}

