//using System;
//using System.Collections.Generic;
//using System.Text;

package slothLib.NLP;

	/**
     * MeCabの出力する形態素情報のクラス
	 * <remarks>
	 * <newpara>[2007-04-22][ohshima]作成</newpara>
	 * </remarks>
	 */
	public class MeCabMorpheme extends Morpheme implements IMorpheme
	{

		// 表層形\t品詞,品詞細分類1,品詞細分類2,品詞細分類3,活用形,活用型,原形,読み,発音

        /**
         * コンストラクタ
         * @param raw 表層形
         * @param pos 品詞
         * @param conjugationPattern 活用形。一般的には活用の種類
         * @param conjugationForm 活用型。一般的には活用形
         * @param original 原形
         * @param reading 読み
         * @param pronunciation 発音
         */
		public MeCabMorpheme(String raw, String pos, String conjugationPattern, String conjugationForm, String original, String reading, String pronunciation)
		{
			super(pos,raw,original);
			this.reading = reading;
			this.conjugationPattern = conjugationPattern;
			this.conjugationForm = conjugationForm;
			this.pronunciation = pronunciation;
		}

		// 読み
		private String reading;
		// 活用型
		private String conjugationPattern;
		// 活用形
		private String conjugationForm;
		// 発音
		private String pronunciation;

		/**
		 * 読み
		 */
		public String getReading()
		{
			return this.reading;
		}

		/**
		 * 活用の種類。MeCabのマニュアル等では「活用形」となっている
		 * <remarks>
		 * MeCabのマニュアルなどでは「活用形」となっていますが、「茶筌」で言うところの活用型であり、五段活用、というような現在の活用の種類のことです。
		 * </remarks>
		 */
		public String getConjugationPattern()
		{
            return this.conjugationPattern; 
		}

		/**
		 * 活用形。MeCabのマニュアル等では「活用型」となっている
		 * <remarks>
		 * MeCabのマニュアルなどでは「活用型」となっていますが、「茶筌」で言うところの活用形であり、未然形、連用形、というような現在の活用の形のことです。
		 * </remarks>
		 */
		public String getConjugationForm()
		{
            return this.conjugationForm;
		}

		/**
		 * 発音
		 */
		public String getPronunciation()
		{
            return this.pronunciation;
		}

        /**
         * "(出現形)\t(品詞),(活用の種類),(活用形),(原形),(読み),(発音)"の形の文字列を返す
         * @return 
         */
		public String toString()
		{
			return this.getRaw() + "\t" + this.getPOS() + "," + this.getConjugationPattern() + "," + this.getConjugationForm() + "," + this.getOriginal() + "," + this.getReading() + "," + this.getPronunciation();
		}




	}

