package slothLib.external.NLP;

import slothLib.NLP.*;


    /**
     * PorterStemmerを利用するフィルタ
     */
    public class PorterStemmerFilter extends AbstractStringFilter
    {
        private PorterStemmer porterStemmer;

        /**
         * コンストラクタ
         */
        public PorterStemmerFilter()
        {
            this.porterStemmer = new PorterStemmer();
        }

        /**
         * PorterStemmerを利用してステミングを行う
         * @param str ステミングを行う文字列
         * @return ステミング語の文字列
         */
        public String doFilter(String str)
        {
            return this.porterStemmer.stemTerm(str);
        }

    }

