package slothLib.NLP;

import java.util.ArrayList;
import java.util.List;

/// <summary>
/// IStringFilterを実装するクラスのための抽象クラス。
/// </summary>
/// <remarks>
/// 
/// <newpara>[2007-05-10][ohshima]作成</newpara>
/// </remarks>
public abstract class AbstractStringFilter implements IStringFilter
{
	/// <summary>
	/// 文字列にフィルタを適用する
	/// </summary>
	/// <param name="str">フィルタを適用する文字列</param>
	/// <returns>フィルタ適用後の文字列</returns>
	public abstract String doFilter(String str);
	
	/// <summary>
	/// 複数の文字列にフィルタを適用する
	/// </summary>
	/// <param name="Strings">フィルタを適用する文字列</param>
	/// <returns>フィルタ適用後の文字列の配列</returns>
	public String[] doFilter(Iterable<String> strings)
	{
		List<String> result = new ArrayList<String>();
		for (String str: strings)
		{
			String filtered = this.doFilter(str);
			if (filtered != null)
			{
				result.add(filtered);
			}
		}
		return result.toArray(new String[0]);
	}

	/// <summary>
	/// 複数の文字列にフィルタを適用する
	/// </summary>
	/// <param name="Strings">フィルタを適用する文字列</param>
	/// <returns>フィルタ適用後の文字列の配列</returns>
	public String[] doFilter(String[] strings)
	{
		List<String> result = new ArrayList<String>();
		for (String str: strings)
		{
			String filtered = this.doFilter(str);
			if (filtered != null)
			{
				result.add(filtered);
			}
		}
		return result.toArray(new String[0]);
	}

}
