package slothLib.NLP;

/// <summary>
/// 半角カタカナ・句読点を全角に，英数を半角にするフィルタ
/// </summary>
/// <remarks>
/// 
/// <newpara>[2007-05-16][kabutoya]作成</newpara>
/// </remarks>
public class AlphaDigitToNarrowHalfKanaToWideFilter extends AbstractStringFilter
{
	/// <summary>
	/// 半角カタカナ・句読点を全角に，英数をを半角にする
	/// </summary>
	/// <param name="str">フィルタを適用する文字列</param>
	/// <returns>フィルタ適用後の文字列</returns>
	public String doFilter(String str)
	{
		return Filter.alphaDigitToNarrowHalfKanaToWide(str);
	}
}

