package slothLib.NLP;
import java.util.*;


public class HankakuZenkaku {
	private static final Map<String, String> zenToHanMap = new HashMap<String, String>(); 
	private static final Map<String, String> hanToZenMap = new HashMap<String, String>(); 
	private static final Map<String, String> hankanaToZenMap = new HashMap<String, String>();
	private static final Set<String> daku_ables = new HashSet<String>();
	
	private static final String zen = 
		"１２３４５６７８９０" +
		"ＡＢＣＤＥＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵＶＷＸＹＺａｂｃｄｅｆｇｈｉｊｋｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚ" +
		"　！”＃＄％＆’（）＊＋，ー．／：；＜＝＞？＠［￥］＾＿‘｛｜｝〜"+
		"あいうえおかきくけこさしすせそたちつてとなにぬねのはひふへほまみむめもやゆよらりるれろわゐゑをんぁぃぅぇぉっゃゅょ" +
		"アイウエオカキクケコサシスセソタチツテトナニヌネノハヒフヘホマミムメモヤユヨラリルレロワヰヱヲンァィゥェォッャュョ" +
		"ー「」。、・";

	private static final String han = 
		"1234567890" +
		"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz" +  
		" !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~" +
		"ｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅﾆﾇﾈﾉﾊﾋﾌﾍﾎﾏﾐﾑﾒﾓﾔﾕﾖﾗﾘﾙﾚﾛﾜｲｴｦﾝｧｨｩｪｫｯｬｭｮ" +
		"ｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅﾆﾇﾈﾉﾊﾋﾌﾍﾎﾏﾐﾑﾒﾓﾔﾕﾖﾗﾘﾙﾚﾛﾜｲｴｦﾝｧｨｩｪｫｯｬｭｮ" +
		"-｢｣｡､･";

	
	private static final String zenKana = 
		"アイウエオカキクケコサシスセソタチツテトナニヌネノハヒフヘホマミムメモヤユヨラリルレロワヰヱヲンァィゥェォッャュョ";
	private static final String hanKana = 
		"ｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅﾆﾇﾈﾉﾊﾋﾌﾍﾎﾏﾐﾑﾒﾓﾔﾕﾖﾗﾘﾙﾚﾛﾜｲｴｦﾝｧｨｩｪｫｯｬｭｮ";

	private static final String daku_hira = 
		"がぎぐげござじずぜぞだぢづでどばびぶべぼぱぴぷぺぽヴ";
	private static final String daku_kata = 
		"ガギグゲゴザジズゼゾダヂヅデドバビブベボパピプペポヴ";
	private static final String daku_han = 
		"ｶﾞｷﾞｸﾞｹﾞｺﾞｻﾞｼﾞｽﾞｾﾞｿﾞﾀﾞﾁﾞﾂﾞﾃﾞﾄﾞﾊﾞﾋﾞﾌﾞﾍﾞﾎﾞﾊﾟﾋﾟﾌﾟﾍﾟﾎﾟｳﾞ";

	static{
		for (int i = 0; i < zen.length(); i++)
			zenToHanMap.put(zen.substring(i, i+1), han.substring(i, i+1));
		for (int i = 0; i < daku_hira.length(); i++)
			zenToHanMap.put(daku_hira.substring(i, i+1), daku_han.substring(2* i, 2 * i+2));
		for (int i = 0; i < daku_kata.length(); i++)
			zenToHanMap.put(daku_kata.substring(i, i+1), daku_han.substring(2* i, 2 * i+2));

		for (int i = 0; i < zen.length(); i++)
			hanToZenMap.put(han.substring(i, i+1), zen.substring(i, i+1));
		for (int i = 0; i < daku_hira.length(); i++)
			hanToZenMap.put(daku_han.substring(2* i, 2 * i+2), daku_kata.substring(i, i+1));

		
		for (int i = 0; i < zenKana.length(); i++)
			hankanaToZenMap.put(hanKana.substring(i, i+1), zenKana.substring(i, i+1));
		for (int i = 0; i < daku_hira.length(); i++)
			hankanaToZenMap.put(daku_han.substring(2* i, 2 * i+2), daku_kata.substring(i, i+1));

		for (int i = 0; i < daku_han.length(); i += 2)
			daku_ables.add(daku_han.substring(i, i+1));
	}
	public static String hanToZen(String str){
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < str.length(); i++){
			String src = str.substring(i, i+1);
			if (daku_ables.contains(src) && i < str.length() - 1 && (str.charAt(i+1) == 'ﾟ' || str.charAt(i+1) == 'ﾞ')){
				src = str.substring(i, i+2);
				i++;
			}
			String dst = hanToZenMap.get(src);
			if (dst == null)
				sb.append(src);
			else
				sb.append(dst);
		}
		return sb.toString();
	}	
	public static String hankanaToZen(String str){
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < str.length(); i++){
			String src = str.substring(i, i+1);
			if (daku_ables.contains(src) && i < str.length() - 1 && (str.charAt(i+1) == 'ﾟ' || str.charAt(i+1) == 'ﾞ')){
				src = str.substring(i, i+2);
				i++;
			}
			String dst = hankanaToZenMap.get(src);
			if (dst == null)
				sb.append(src);
			else
				sb.append(dst);
		}
		return sb.toString();	
	}
	public static String zenToHan(String str){
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < str.length(); i++){
			String src = str.substring(i, i+1);
			String dst = zenToHanMap.get(src);
			if (dst == null)
				sb.append(src);
			else
				sb.append(dst);
		}
		return sb.toString();
	}
	

	public static void main(String [] args){
		String test = "んに...ちは．てすとです．＜^>こんに...ちは．てすとです．＜^>漢字も入れてみた．ヱヴァンゲリヲン こで";
		String test2 = "あ122345ああﾃｽﾄ";
		
		System.out.println(test);
		String tmp0 = HankakuZenkaku.zenToHan(test);
		System.out.println(tmp0);
		
		String tmp1 = HankakuZenkaku.hanToZen(tmp0);
		System.out.println(tmp1);
		
		String tmp2 = HankakuZenkaku.hankanaToZen(test2);
		System.out.println(tmp2);
	}
	
}
