package slothLib.NLP;
/// <summary>
/// 形態素から文字列に変換するフィルタのインタフェース
/// </summary>
public interface IMorphemeToStringFilter
{
	/// <summary>
	/// 形態素を文字列に変換する
	/// </summary>
	/// <param name="morpheme">フィルタを適用する形態素</param>
	/// <returns>フィルタ適用後の文字列</returns>
	String doFilter(IMorpheme morpheme);
	/// <summary>
	/// 形態素の配列を文字列の配列に変換する
	/// </summary>
	/// <param name="morphemes">フィルタを適用する形態素の配列</param>
	/// <returns>フィルタ適用後の文字列の配列</returns>
	String[] doFilter(Iterable<IMorpheme> morphemes);
	
	String[] doFilter(IMorpheme [] morphemes);
}
