package slothLib.NLP;

/**
 * 形態素解析によって解析された形態素1つのクラス
 * <remarks>
 */
public class Morpheme implements IMorpheme{

	private String pos;
	private String raw;
	private String original;
	
	/**
	 * コンストラクタ
	 * @param pos 品詞
	 * @param raw 出現形
	 * @param original 原形
	 */
	public Morpheme(String pos, String raw, String original)
	{
		this.pos = pos;
		this.raw = raw;
		this.original = original;
	}
	
	/**
	 * 品詞
	 */
	public String getPOS()
	{
		return this.pos;
	}
	
	/**
	 * 出現形
	 */
	public String getRaw()
	{
		return this.raw;
	}
	
	/**
	 * 原形
	 */
	public String getOriginal()
	{
		return this.original;
	}
	
	/**
	 * "[Raw](出現形)\t[POS](品詞)\t[Original](原形)"の形の文字列を返す
	 * @return 
	 */
	public String toString()
	{
		return "[Raw]" + this.getRaw() + "\t[POS]" + this.getPOS() + "\t[Original]" + this.getOriginal();
	}

}
