
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.layout.GridData;

import slothLib.SlothLibException;
import slothLib.NLP.IMorpheme;
import slothLib.NLP.MeCabResult;
import slothLib.NLP.MeCabServer;

public class MeCabSample {

	private Shell sShell = null;  //  @jve:decl-index=0:visual-constraint="10,10"
	private Text textArea = null;
	private Button button = null;
	private Text textArea1 = null;

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO 自動生成されたメソッド・スタブ
		/* Before this is run, be sure to set up the launch configuration (Arguments->VM Arguments)
		 * for the correct SWT library path in order to run with the SWT dlls. 
		 * The dlls are located in the SWT plugin jar.  
		 * For example, on Windows the Eclipse SWT 3.1 plugin jar is:
		 *       installation_directory\plugins\org.eclipse.swt.win32_3.1.0.jar
		 */
		Display display = Display.getDefault();
		MeCabSample thisClass = new MeCabSample();
		thisClass.createSShell();
		thisClass.sShell.open();

		while (!thisClass.sShell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		display.dispose();
	}

	/**
	 * This method initializes sShell
	 */
	private void createSShell() {
		GridData gridData2 = new GridData();
		gridData2.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData2.grabExcessVerticalSpace = true;
		gridData2.verticalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData2.grabExcessHorizontalSpace = true;
		GridData gridData1 = new GridData();
		gridData1.horizontalAlignment = org.eclipse.swt.layout.GridData.CENTER;
		GridData gridData = new GridData();
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData.verticalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData.grabExcessVerticalSpace = true;
		sShell = new Shell();
		sShell.setText("MeCab it");
		sShell.setSize(new Point(497, 393));
		sShell.setLayout(new GridLayout());
		textArea = new Text(sShell, SWT.MULTI | SWT.WRAP | SWT.V_SCROLL | SWT.BORDER);
		textArea.setLayoutData(gridData2);
		button = new Button(sShell, SWT.NONE);
		button.setText("Mecab it");
		button.setLayoutData(gridData1);
		button.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				textArea1.setText(mecabIt(textArea.getText()));
			}
		});
		textArea1 = new Text(sShell, SWT.MULTI | SWT.WRAP | SWT.V_SCROLL | SWT.BORDER);
		textArea1.setLayoutData(gridData);
	}

	private String mecabIt(String text){
		MeCabServer mecab;
		try {
			StringBuffer sb = new StringBuffer();
			mecab = new MeCabServer();
			MeCabResult result = mecab.doAnalyze(text);
			//sb.append(result.getRawResult() + "\n");
			for (IMorpheme s: result.getMorphemes())
				sb.append(s + "\n");
			return sb.toString();
		} catch (SlothLibException e) {
			return "error: " + e.getMessage();
		}
	}
	
	
	
}
