package slothLib.linearAlgebra.featureVector;

/**
 * 最短距離法
 * <typeparam name="T"></typeparam>
 */
public class CentroidClusteringProcess<T> extends
		HierarchicalClusteringProcess<T> {

	/**
	 * そのクラスタに属しているアイテムの数を格納しておくもの
	 */
	protected int[] itemCountInCluster;

	/**
	 * そのクラスタの代表ベクトルを格納しておくもの
	 */
	protected IVector<T>[] centroidVectors;

	/**
	 * コンストラクタ
	 * @param vectors 
	 * @param calculator 
	 * @param dType 
	 */
	public CentroidClusteringProcess(IVector<T>[] vectors, ICalculatorScalarFromTwoVectors<T> calculator, ClusteringDistanceType dType)
	{
		super(vectors, calculator, dType);
		itemCountInCluster = new int[this.itemCount];
		centroidVectors = (IVector<T>[])(new Object[this.itemCount]);
		for (int i = 0; i < this.itemCount; i++)
		{
			// はじめは全部1つ。
			itemCountInCluster[i] = 1;
			// はじめは全部自分自身のベクトル（高速化のため計算済みの値で保持。）
			centroidVectors[i] = new BasicVector<T>(vectors[i]);
		}
	}

	/**
	 * デンドログラムのノードを取得する
	 * @param cid1 
	 * @param cid2 
	 * @param minDistance 
	 * @return 
	 */
	protected IDendrogramNode<T> getDendrogramNode(int cid1, int cid2, double minDistance)
	{
		return new CentroidDendrogramNode<T>(cid1, cid2, minDistance, centroidVectors[cid1]);
	}

	/**
	 * クラスタを結合する
	 * @param cid1 
	 * @param cid2 
	 */
	protected void union(int cid1, int cid2)
	{
		// クラスタ番号の更新
		clusterID[cid2] = cid1;

		// 合成されたクラスタの代表ベクトルの更新
		IVector<T> v1 = new MultiplyVector<T>(itemCountInCluster[cid1], centroidVectors[cid1]);
		IVector<T> v2 = new MultiplyVector<T>(itemCountInCluster[cid2], centroidVectors[cid2]);
		int c = itemCountInCluster[cid1] + itemCountInCluster[cid2];
		IVector<T> v = new MultiplyVector<T>(1.0 / c, new AddVector<T>(v1, v2));
		centroidVectors[cid1] = v;
		// アイテム数の更新
		itemCountInCluster[cid1] = c;

		// 距離テーブルの更新
		for (int i = 0; i < this.itemCount; i++)
		{
			// クラスタの代表ではなかったり、距離テーブルの対角成分は更新・参照の対象ではない。
			if (clusterID[i] != i || i == cid1 || i == cid2)
			{
				continue;
			}

			setDistance(cid1, i, this.calculator.doCalculate(centroidVectors[i], v) * this.ds);
		}
	}

}
