package slothLib.linearAlgebra.featureVector;

public class Cluster <T>{
	IVector<T>[] vectors;
	int[] indices;
	IVector<T> centroidVector;

	/**
	 * コンストラクタ
	 * @param vectors 
	 * @param indices 
	 * @param centroidVector 
	 */
	public Cluster(IVector<T>[] vectors, int[] indices, IVector<T> centroidVector)
	{
		this.vectors = vectors;
		this.indices = indices;
		this.centroidVector = centroidVector;
	}

	/**
	 * このクラスタに含まれるアイテムのベクトル群を取得する
	 * @return 
	 */
	public IVector<T>[] GetVectors()
	{
		return this.vectors;
	}


	/**
	 * クラスタリングされるときに与えられたベクトル配列のインデックスのうち、このクラスタに含まれるものを取得する
	 * @return 
	 */
	public int[] GetIndices()
	{
		return this.indices;
	}


	/**
	 * このクラスタにあるアイテムの数
	 */
	public int itemCount(){
		return this.vectors.length;
	}		


	/**
	 * 指定されたベクトルのアイテムがこのクラスタにあるかどうか
	 * @param vector 
	 * @return 
	 */
	public boolean contains(IVector<T> vector)
	{
		for (IVector<T> v: this.vectors)
		{
			if (v == vector)
			{
				return true;
			}
		}
		return false;
	}

	/**
	 * 指定されたインデックスのアイテムがこのクラスタにあるかどうか
	 * @param index 
	 * @return 
	 */
	public boolean contains(int index)
	{
		for (int i: this.indices)
		{
			if (i == index)
			{
				return true;
			}
		}
		return false;
	}


	/**
	 * 重心のベクトルを取得する。
	 * セントロイド法の場合はキャッシュされているので取得が速い。
	 * Ward法が実装された場合は、Ward法による重心が返される。
	 * @return 
	 */
	public IVector<T> getCentroidVector()
	{
		if (this.centroidVector == null)
		{
			// セントロイド法的重心を求める。
			IVector<T> v = new MultiplyVector<T>(1.0 / this.itemCount(), new AddVector<T>(this.vectors));
			this.centroidVector = v;
		}
		return this.centroidVector;
	}


}

