package slothLib.linearAlgebra.featureVector;

import java.util.Iterator;

public class ClusteringResult<T> implements Iterable<Cluster<T>>{

	private Cluster<T>[] _clusters;

	public ClusteringResult(Cluster<T>[] clusters)
	{
		this._clusters = clusters;
	}

	public int clusterCount(){
		return _clusters.length;
	}
	
	public Cluster<T>[] clusters()
	{
		return this._clusters;
	}
	

	/**
	 * 指定されたベクトルを含むクラスタを返す。
	 * @param vector 
	 * @return 
	 */
	public Cluster<T> getClusterByVector(IVector<T> vector)
	{
		for (Cluster<T> c: this._clusters)
		{
			if (c.contains(vector))
			{
				return c;
			}
		}
		return null;
	}

	/**
	 * 指定されたインデックスのベクトルを含むクラスタを返す。
	 * @param index 
	 * @return 
	 */
	public Cluster<T> getClusterByIndex(int index)
	{
		for (Cluster<T> c: this._clusters)
		{
			if (c.contains(index))
			{
				return c;
			}
		}
		return null;
	}


	///
	public Iterator<Cluster<T>> iterator() {
		return new ClusterIterator();
	}
	
	class ClusterIterator< T> implements Iterator<Cluster<T>>{
		int index = 0;

		public boolean hasNext() {
			return index < _clusters.length;
		}

		public Cluster<T> next() {
			return (Cluster<T>) _clusters[index++];
		}
		
		public void remove() {
			// nothing to do
		}

	}
	

}
