package slothLib.linearAlgebra.featureVector;

/**
 * 群平均法
 * <typeparam name="T"></typeparam>
 */
public class GroupAverageClustering<T> extends HierarchicalClustering<T>
{

	/**
	 * 距離を距離テーブル作成に用いる
	 * @param distanceCalculator 
	 */
	public GroupAverageClustering(IDistanceCalculator<T> distanceCalculator)
	{
		super(distanceCalculator);
	}

	/**
	 * 類似度を距離テーブル作成に用いる
	 * @param similarityCalculator 
	 */
	public GroupAverageClustering(ISimilarityCalculator<T> similarityCalculator)
	{
		super(similarityCalculator);
	}

	/**
	 * クラスタリングを実際に行うクラスを返す
	 * @param vectors 
	 * @return 
	 */
	protected IHierarchicalClusteringProcess<T> getProcess(IVector<T>[] vectors)
	{
		return new GroupAverageClusteringProcess<T>(vectors, this.calculator, this.dType);
	}

}
