package slothLib.linearAlgebra.featureVector;

/**
 * 階層型クラスタリングを行うクラスの抽象クラス
 */
public abstract class HierarchicalClustering<T> implements IHierarchicalClustering<T>{
	// <summary>
	// 距離の最長値
	// </summary>
	//public const double INFINITE_DISTANCE = System.Double.MaxValue;

	/**
	 * 距離テーブルの計算器
	 */
	protected ICalculatorScalarFromTwoVectors<T> calculator;

	/**
	 * 距離テーブルの計算器タイプ
	 */
	protected ClusteringDistanceType dType;



	/**
	 * 距離を距離テーブル作成に用いる
	 * @param distanceCalculator 
	 */
	public HierarchicalClustering(IDistanceCalculator<T> distanceCalculator)
	{
		this.calculator = distanceCalculator;
		this.dType = ClusteringDistanceType.Distance;
	}

	/**
	 * 類似度を距離テーブル作成に用いる
	 * @param similarityCalculator 
	 */
	public HierarchicalClustering(ISimilarityCalculator<T> similarityCalculator)
	{
		this.calculator = similarityCalculator;
		this.dType = ClusteringDistanceType.Similarity;
	}


	/**
	 * クラスタリングを実際に行うクラスを返す
	 * @param vectors 
	 * @return 
	 */
	protected abstract IHierarchicalClusteringProcess<T> getProcess(IVector<T>[] vectors);


	/**
	 * クラスタの数が指定値になるか、互いのクラスタの距離が指定値より遠くなるまで階層的クラスタリングを行う
	 * @param vectors 
	 * @param thresholdClusterCount クラスタリングを止める閾値となるクラスタ数
	 * @param thresholdDistanceOrSimilarity クラスタリングを止める閾値となる距離または類似度
	 * @return 
	 */
	public HierarchicalClusteringResult<T> doClustering(IVector<T>[] vectors, int thresholdClusterCount, double thresholdDistanceOrSimilarity)
	{
		IHierarchicalClusteringProcess<T> process = getProcess(vectors);
		return process.doClustering(thresholdClusterCount, thresholdDistanceOrSimilarity);
	}

	/**
	 * クラスタが1つになるまで階層的クラスタリングを行う
	 * @param vectors 
	 * @return 
	 */
	public HierarchicalClusteringResult<T> doClustering(IVector<T>[] vectors)
	{
		IHierarchicalClusteringProcess<T> process = getProcess(vectors);
		return process.doClustering();
	}

	/**
	 * クラスタの数が指定値になるまで階層的クラスタリングを行う
	 * @param vectors 
	 * @param thresholdClusterCount 
	 * @return 
	 */
	public HierarchicalClusteringResult<T> doClustering(IVector<T>[] vectors, int thresholdClusterCount)
	{
		IHierarchicalClusteringProcess<T> process = getProcess(vectors);
		return this.doClustering(vectors, thresholdClusterCount);
	}

	/**
	 * 互いのクラスタの距離が指定値より遠くなるまで階層的クラスタリングを行う
	 * @param vectors 
	 * @param thresholdDistanceOrSimilarity 
	 * @return 
	 */
	public HierarchicalClusteringResult<T> doClustering(IVector<T>[] vectors, double thresholdDistanceOrSimilarity)
	{
		IHierarchicalClusteringProcess<T> process = getProcess(vectors);
		return this.doClustering(vectors, thresholdDistanceOrSimilarity);
	}



	
	
}
