package slothLib.linearAlgebra.featureVector;

public interface IHierarchicalClustering<T> {
	/**
	 * クラスタが1つになるまで階層的クラスタリングを行う
	 * @param vectors 
	 * @return 
	 */
	HierarchicalClusteringResult<T> doClustering(IVector<T>[] vectors);

	/**
	 * クラスタの数が指定値になるまで階層的クラスタリングを行う
	 * @param vectors 
	 * @param thresholdClusterCount 
	 * @return 
	 */
	HierarchicalClusteringResult<T> doClustering(IVector<T>[] vectors, int thresholdClusterCount);

	/**
	 * 互いのクラスタの距離が指定値より遠くなるまで階層的クラスタリングを行う
	 * @param vectors 
	 * @param thresholdDistanceOrSimilarity 
	 * @return 
	 */
	HierarchicalClusteringResult<T> doClustering(IVector<T>[] vectors, double thresholdDistanceOrSimilarity);

	/**
	 * クラスタの数が指定値になるか、互いのクラスタの距離が指定値より遠くなるまで階層的クラスタリングを行う
	 * @param vectors 
	 * @param thresholdClusterCount 
	 * @param thresholdDistanceOrSimilarity 
	 * @return 
	 */
	HierarchicalClusteringResult<T> doClustering(IVector<T>[] vectors, int thresholdClusterCount, double thresholdDistanceOrSimilarity);
	
	

}
