package slothLib.linearAlgebra.featureVector;

import java.util.Set;
import java.util.List;
/*
 * Base vector that stores double value with 
 * keys of specified type <T>. 
 */

public interface IVector<T> extends Cloneable {
	/*
	 * replace this[<E>]
	 */
	double get(T e);	
	void set(T e, double val);

	/**
	 * replaces Keys property
	 * @return set of keys
	 */	
	Set<T> keys();
	
	/**
	 * 
	 * @return non-zero values
	 */
	List<T> keyList();

	/**
	 * return sorted key list
	 * @return sorted key list
	 */
	List<T> getSortedKeyList();

	
	/**
	 * to implement clonable
	 */

	Object clone();
}
