package slothLib.linearAlgebra.featureVector;

public class LogVector<T> extends BasicVector<T>{
	public LogVector(IVector<T> vector) {
		this(vector, 2.0, 1.0);
	}
	public LogVector(IVector<T> vector, double baseValue, double addValue) {
		for (T key: vector.keys()){
			if (vector.get(key) <= 0.0)
				this.set(key, Math.log(addValue + vector.get(key)) / Math.log(baseValue));
			else
				this.set(key, Math.log(vector.get(key)) / Math.log(baseValue));
		}

	}
}
