package slothLib.linearAlgebra.featureVector;

public class VectorOperator{
	
	/**
	 * 
	 * @param vector input vector
	 * @param p      parameter, have to be more than 1
	 * @return 
	 */
	public static <T> double GetPNorm(IVector<T> vector, double p){
		double d = 0.0;
		for (T key : vector.keys()){
			d += Math.pow(vector.get(key), p);
		}		
		return Math.pow(d, 1/p);
	}

	public static <T> double getEuclideanDistance(IVector<T> vector){
		double d = 0.0;
		for (T key: vector.keys()){
			d = d + Math.pow(vector.get(key), 2.0);
		}
		return Math.sqrt(d);
	}

	
	public static <T> double getMaxElement(IVector<T> vector){
		return vector.get(getMaxElementKey(vector));
	}
	
	private static <T> T getMaxElementKey(IVector<T> vector){
		double max = 0.0;
		T maxkey = null;
		// originally: maxkey = default(T); not sure this makes sense
		for (T key: vector.keys()){
			if (max < vector.get(key)){
				max = vector.get(key);
				maxkey =key;
			}
		}
		return maxkey;
	}

	public static <T> T getMinElementKey(IVector<T> vector) {
		double min = 0;
		T minkey = null;
		
		for (T key: vector.keys()) {
			if (min > vector.get(key)) {
				min = vector.get(key);
				minkey = key;
			}
		}
		return minkey;
	}

	public static <T> double getMinElement(IVector<T> vector) {
		T key = getMinElementKey(vector);
		return vector.get(key);
	}

	public static <T> T getMaxAbsElementKey(IVector<T> vector){
		double absmax = 0;
		T absmaxkey = null;
		
		for (T key: vector.keys()) {
			if (absmax < Math.abs(vector.get(key))){
				absmax = Math.abs(vector.get(key));
				absmaxkey = key;
			}
		}
		return absmaxkey;
	}

    	
	public static <T> double getMaxNorm(IVector<T> vector){
		return vector.get(getMaxAbsElementKey(vector));
	}

	public static <T> double getAllElementSum(IVector<T> vector){
		double sum = 0;
		for (T key: vector.keys()){
			sum += vector.get(key);
		}
		return sum;
	}

	public static <T> double getEuclideanDistance(IVector<T> vector1, IVector<T> vector2){
		IVector<T> sub = subtract(vector1, vector2);
		return getEuclideanDistance(sub);
	}

	
	public static <T> double getManhattanDistance(IVector<T> vector1, IVector<T> vector2){
		double d = 0.0;
		IVector<T> sub = subtract(vector1, vector2);
		for (T key: sub.keys()){
			d = d + Math.abs(vector1.get(key));
		}
		return d;
	}

	public static <T> double getInnerProduct(IVector<T> vector1, IVector<T> vector2){
		double ip = 0.0;
		for (T key: vector1.keys()){
			ip += vector1.get(key) * vector2.get(key);
		}
		return ip;
	}

    public static <T> double getCosine(IVector<T> vector1, IVector<T> vector2){
        double ip = getInnerProduct(vector1, vector2);
        if (ip == 0){
            return 0.0;
        }
        double v1Length = getEuclideanDistance(vector1);
        double v2Length = getEuclideanDistance(vector2);
        double cos = ip / (v1Length * v2Length);
        return cos;
    }

    public static <T> double getJaccardCoefficient(IVector<T> vector1, IVector<T> vector2){
    	double v1 = 0, v2 = 0;
    	double inner = getInnerProduct(vector1, vector2);
    	
    	for (T key: vector1.keys())
    		v1 += vector1.get(key) * vector1.get(key);
    	
    	for (T key: vector2.keys())
    		v2 += vector2.get(key) * vector2.get(key);
    	
    	return inner / (v1 + v2 - inner);
    }

    public static <T> double getDiceCoefficient(IVector<T> vector1, IVector<T> vector2){
    	double v1 = 0, v2 = 0;
    	
    	for (T key: vector1.keys())
    		v1 += vector1.get(key) * vector1.get(key);
    	for (T key: vector2.keys())
    		v2 += vector2.get(key) * vector2.get(key);

    	return 2 * getInnerProduct(vector1, vector2) / v1 / v2;
    }


	
    /**
     * 
     * @param vector1 
     * @param vector2
     * @return 
     */
    public static <T> IVector<T> add(IVector<T> vector1, IVector<T> vector2){
    	@SuppressWarnings("unchecked")
    	IVector<T> r = (IVector<T>) vector1.clone();
    	for (T key: vector2.keys()){
    		r.set(key, r.get(key) + vector2.get(key));
    	}
    	return r;
    }       
    
    public static <T> IVector<T> subtract(IVector<T> vector1, IVector<T> vector2){
    	return add(vector1, negate(vector2));
    }

    
    public static <T> IVector<T> negate(IVector<T> vector){
        IVector<T> r = (IVector<T>)vector.clone();
        for (T key: vector.keys())
            r.set(key, -vector.get(key));
        return r;
    }


    /**
     * ベクトルの定数倍を行う
     */
    public static <T> IVector<T> multiply(double scalar, IVector<T> vector)
    {
        IVector<T> r = (IVector<T>)vector.clone();
        for (T key: vector.keys())
        	r.set(key, scalar * r.get(key));
        return r;
    }
    
}

    
