package slothLib.linearAlgebra.matrix;

/**
 * 行列の逆数を取った行列
 * Value = 1.0 / Value
 * ただし，0の要素に対しては逆数は取らない
 */
public class InverseMatrix extends BasicMatrix {
    public InverseMatrix(IMatrix matrix)
    {
        super(matrix.rowCount(), matrix.columnCount());

        for (int i = 0; i < matrix.rowCount(); i++)
        {
            for (int j = 0; j < matrix.columnCount(); j++)
            {
                if (matrix.get(i, j) != 0.0)
                {
                    set(i, j, 1.0 / matrix.get(i, j));
                }
                else
                {
                	set(i, j, 0.0); 
                }

            }
        }
    }

}
