package slothLib.linearAlgebra.matrix;

import java.lang.IllegalArgumentException;

public class MatrixOperator {
    /**
     * 行列にある要素のうち、0以上の値をもつ要素の最大値を取得する
     * @param matrix 
     * @return 行列の要素中の最大値
     */
    static double getMaxElement(IMatrix matrix)
    {
        double max = Double.MIN_VALUE;

        for (int i = 0; i < matrix.rowCount(); i++)
        {
            for (int j = 0; j < matrix.columnCount(); j++)
            {
                if (max < matrix.get(i, j))
                {
                    max = matrix.get(i, j);
                }
            }
        }

        return max;
    }


    /**
     *  行列にある要素のうち、0以下の値をもつ要素の最小値を取得する
     * @param matrix 
     * @return 
     */
    static double getMinElement(IMatrix matrix)
    {
        double min = Double.MAX_VALUE;

        for (int i = 0; i < matrix.rowCount(); i++)
        {
            for (int j = 0; j < matrix.columnCount(); j++)
            {
                if (min > matrix.get(i, j))
                {
                    min = matrix.get(i, j);
                }
            }
        }

        return min;
    }

    /**
     * 行列の要素のうち絶対値が最大となるものの値を返す
     * @param matrix 
     * @return 
     */
    public static double getMaxNorm(IMatrix matrix)
    {
        double absMax = Double.MIN_VALUE;

        for (int i = 0; i < matrix.rowCount(); i++)
        {
            for (int j = 0; j < matrix.columnCount(); j++)
            {
                if (absMax < Math.abs(matrix.get(i, j)))
                {
                    absMax = Math.abs(matrix.get(i, j));
                }
            }
        }

        return absMax;
    }


    /**
     * 行列の全要素の値の総和を返す
     * @param matrix 
     * @return 
     */
    public static double getAllElementSum(IMatrix matrix)
    {
        double sum = 0.0;

        for (int i = 0; i < matrix.rowCount(); i++)
        {
            for (int j = 0; j < matrix.columnCount(); j++)
            {
                sum += matrix.get(i, j);
            }
        }

        return sum;
    }

    /**
     * 行列の加算
     * @param matrix1 
     * @param matrix2 
     * @return 
     */
    public static IMatrix add(IMatrix matrix1, IMatrix matrix2)
	{
		if ((matrix1.rowCount() != matrix2.rowCount()) || (matrix1.columnCount() != matrix2.columnCount()))
		{
			// 現時点ではエラーを投げて終了
			throw new IllegalArgumentException("左行列と右行列とで行数及び列数が一致しません");
		}

		IMatrix resultMatrix = (IMatrix)matrix1.clone();

		for (int i = 0; i < resultMatrix.rowCount(); i++)
		{
			for (int j = 0; j < resultMatrix.columnCount(); j++)
			{
				resultMatrix.set(i, j, resultMatrix.get(i, j) + matrix2.get(i, j));
			}
		}

		return resultMatrix;
	}


	/**
	 * 行列の減算
	 * @param matrix1 
	 * @param matrix2 
	 * @return 
	 */
	public static IMatrix subtract(IMatrix matrix1, IMatrix matrix2)
	{
		if ((matrix1.rowCount() != matrix2.rowCount()) || (matrix1.columnCount() != matrix2.columnCount()))
		{
			// 現時点ではエラーを投げて終了
			throw new IllegalArgumentException("左行列と右行列とで行数及び列数が一致しません");
		}

		IMatrix resultMatrix = (IMatrix)matrix1.clone();

		for (int i = 0; i < resultMatrix.rowCount(); i++)
		{
			for (int j = 0; j < resultMatrix.columnCount(); j++)
			{
				resultMatrix.set(i, j,  resultMatrix.get(i,j) - matrix2.get(i, j));
			}
		}

		return resultMatrix;
	}

	/**
	 * 行列の負
	 * @param matrix 
	 * @return 
	 */
	public static IMatrix negate(IMatrix matrix)
	{
		IMatrix resultMatrix = (IMatrix)matrix.clone();

		for (int i = 0; i < resultMatrix.rowCount(); i++)
		{
			for (int j = 0; j < resultMatrix.columnCount(); j++)
			{
				resultMatrix.set(i, j, -matrix.get(i, j));
			}
		}

		return resultMatrix;
	}


	/**
	 * 行列の定数倍
	 * @param scalar 
	 * @param matrix 
	 * @return 
	 */
	public static IMatrix multiply(double scalar, IMatrix matrix)
	{
		IMatrix resultMatrix = (IMatrix)matrix.clone();

		for (int i = 0; i < resultMatrix.rowCount(); i++)
		{
			for (int j = 0; j < resultMatrix.columnCount(); j++)
			{
				resultMatrix.set(i, j, scalar * matrix.get(i, j));
			}
		}

		return resultMatrix;
	}

}
