package slothLib.linearAlgebra.matrix;

/**
 * 累乗
 * Value = Value ^ exponent
 */

public class PowerMatrix extends BasicMatrix {

	public PowerMatrix(IMatrix matrix, double exponent)
    {
        super(matrix.rowCount(), matrix.columnCount());

    	for (int i = 0; i < matrix.rowCount(); i++)
        {
        	for (int j = 0; j < matrix.columnCount(); j++)
            {
        		set(i, j, Math.pow(matrix.get(i, j), exponent));
            }
        }
    }

}
