package slothLib.linearAlgebra.vector;

public class EuclideanDistanceCalculator implements IDistanceCalculator {

	/**
	 * 原点からのユークリッド距離を計算する。
	 * @param vector 
	 * @return 
	 */
	public double doCalculate(IVector vector)
	{
		return VectorOperator.getEuclideanDistance(vector);
	}

	/**
	 * 2つのベクトル間のユークリッド距離を計算する。
	 * @param vector1 
	 * @param vector2 
	 * @return 
	 */
	public double doCalculate(IVector vector1, IVector vector2)
	{
		return VectorOperator.getEuclideanDistance(vector1, vector2);
	}

}
