package slothLib.portUtil;

import java.io.*;

/**
 * 
 * @author nakada
 *
 * Redirect Runnable.
 * if the Stream is just for logging or printing,  
 * Use MutliRedirector instead.
 */

public class Redirector implements Runnable{
  InputStream  is;
  OutputStream os;


  // if os == null, it will just throw the data away
  
  public static void redirect(InputStream is, OutputStream os){
	  Thread t = (new Thread(new Redirector(is, os), "Redirect Thread"));
	  // t.setDaemon(true);
	  t.start();
  }
  
  public Redirector(InputStream is, OutputStream os){
    this.is = is;
    this.os = os;
  }
  
  public void run() {
    byte [] buffer = new byte[4096];
    int read;
    try {
    	while ((read = is.read(buffer)) >= 0){
    		if (os != null)
    			os.write(buffer, 0, read);
    	}
        if (os != null)
        	os.close();
    } catch (InterruptedIOException e){
    } catch (IOException e){
    	e.printStackTrace();
    } catch (Error e){
    	e.printStackTrace();
    }
  }
}
