//using System;
//using System.Collections.Generic;
//using System.Text;
//using System.Runtime.Serialization;

package slothLib.web.search;

import java.io.Serializable;
    /**
     * GoogleAPIの結果を格納するクラス
     */
    
    public class GoogleSOAPElement implements IWebElement, IRankedElement, Serializable
    {
        // privateフィールド

        int rank;

        String url;
        String title;
        String description;



        // コンストラクタ

        /**
         * コンストラクタ
         * @param rank 検索エンジンにつけられたランキング
         * @param url ページのURL
         * @param title ページのタイトル
         * @param description ページの要約
         */
        public GoogleSOAPElement(int rank, String url, String title, String description)
        {
            this.rank = rank;
            this.url = url;
            this.title = title;
            this.description = description;
        }



        // プロパティ

        /**
         * ページのタイトル
         */
        public String getTitle()
        {
        	return this.title;
        }

        /**
         * ページの要約
         */
        public String getDescription()
        {
        	return this.description;
        }

        /**
         * ページのURL
         */
        public String getURL()
        {
                return this.url;
        }



//        //#region ISerializable メンバ
//
//        /// <summary>
//        /// シリアライズ化するときに呼び出される関数
//        /// </summary>
//        /// <param name="info">逆シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//        public void GetObjectData(SerializationInfo info, StreamingContext context)
//        {
//            info.AddValue("rank", this.rank);
//            info.AddValue("title", this.title);
//            info.AddValue("description", this.description);
//            info.AddValue("url", this.url);
//        }
//
//        /// <summary>
//		/// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
//		/// </summary>
//        /// <param name="info">シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//		protected GoogleSOAPElement(SerializationInfo info, StreamingContext context)
//		{
//            this.rank = info.GetInt32("rank");
//            this.title = info.GetString("title");
//            this.description = info.GetString("description");
//            this.url = info.GetString("url");
//		}
//
//        //#endregion

        // ISearchResultElement メンバ

        /**
         * ページのURL
         */
//        String ISearchResultElement.URL
//        {
//            get { return this.url; }
//        }
//
//        /// <summary>
//        /// ページのタイトル
//        /// </summary>
//        String ISearchResultElement.Title
//        {
//            get { return this.title; }
//        }
//
//        /// <summary>
//        /// ページの要約
//        /// </summary>
//        String ISearchResultElement.Description
//        {
//            get { return this.Description; }
//        }



        // IRankedElement メンバ

        /**
         * 検索エンジンにつけられたランキング
         */
        public int getRank()
        {
            return this.rank; 
        }


    }

