//using System;
//using System.Collections.Generic;
//using System.Text;
//using System.Runtime.Serialization;

package slothLib.web.search;

import java.io.Serializable;

    /**
     * LiveSearch検索が返す検索結果全体。
     */
    public class LiveWebSearchResult implements IWebSearchResult, Serializable
    {
        // private プロパティ

        private String query;
        private long totalNumber;
        private LiveWebElement[] resultElements;



        // コンストラクタ

        /**
         * コンストラクタ
         * @param query 検索クエリ
         * @param totalNumber 総検索数
         * @param resultElements 検索結果要素
         */
        public LiveWebSearchResult(String query, long totalNumber, LiveWebElement[] resultElements)
        {
            this.query = query;
            this.totalNumber = totalNumber;
            this.resultElements = resultElements;

        }



        // プロパティ

        /**
         * 検索クエリ
         */
        public String getQuery()
        {
        	return this.query;
        }

        /**
         * 総検索数
         */
        public long getTotalNumber()
        {
        	return this.totalNumber;
        }

        /**
         * 検索結果要素
         */
        public LiveWebElement[] getResultElements()
        {
        	return this.resultElements;
        }



//        //#region IWebSearchResult メンバ
//
//        /// <summary>
//        /// 検索結果要素の配列
//        /// </summary>
//        IWebElement[] IWebSearchResult.ResultElements
//        {
//            get
//            {
//                return this.resultElements;
//            }
//        }
//
//        //#endregion
//
//        //#region ISearchResult メンバ
//
//        /// <summary>
//        /// 検索結果要素の配列
//        /// </summary>
//        ISearchResultElement[] ISearchResult.ResultElements
//        {
//            get
//            {
//                return this.resultElements;
//            }
//        }
//
//        /// <summary>
//        /// 検索に使われたクエリ
//        /// </summary>
//        String ISearchResult.Query
//        {
//            get
//            {
//                return this.query;
//            }
//        }
//        /// <summary>
//        /// 総検索数
//        /// </summary>
//        long ISearchResult.getTotalNumber()
//        {
//            {
//                return this.totalNumber;
//            }
//        }



//        //#region ISerializable メンバ
//
//
//        /// <summary>
//        /// シリアライズ化するときに呼び出される関数
//        /// </summary>
//        /// <param name="info">逆シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
//        {
//            info.AddValue("query", this.query);
//			info.AddValue("totalNumber", this.totalNumber);
//            info.AddValue("resultElements", this.resultElements);
//        }
//
//        /// <summary>
//        /// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
//        /// </summary>
//        /// <param name="info">シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//        protected LiveWebSearchResult(SerializationInfo info, StreamingContext context)
//        {
//            this.query = info.GetString("query");
//            this.totalNumber = info.GetInt64("totalNumber");
//            this.resultElements = (LiveWebElement[])info.GetValue("resultElements", typeof(LiveWebElement[]));
//        }
//
//        //#endregion
    }

