//﻿using System;
//using System.Collections.Generic;
//using System.Text;

//using System.Runtime.Serialization;

package slothLib.web.search;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import slothLib.portUtil.PortUtil;

    /**
     * 教えて！Goo検索の要素
     * <remarks>
     * 

     * <newpara>[2007-06-12][inagawa]作成</newpara>
     * </remarks>
     */
    public class OshieteGooElement implements ISearchResultElement, IRankedElement
    {
        // privateフィールド

        private String url;
        private String title;
        private String description;
        private String date;
        private String category;
        private String author;
        private int rank; //one origin



        // プロパティ

        /**
         * 質問ページのURL
         */
        public String getURL()
        {
        	return url; 
        }
        /**
         * タイトル
         */
        public String getTitle()
        {
            return title; 
        }
        /**
         * 質問文の一部
         */
        public String getDescription()
        {
            return description; 
        }
        /**
         * 投稿日時
         */
        public Date getDate()
        {
        	//更新日時がない場合、何もしない
        	if (PortUtil.isNullOrEmpty(this.date))
        	{
        		return new Date();
        	}
        	else
        	{
        		//更新日時の文字列をDateTime型に変換
        		try
        		{
        			return (new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:sszzz")).parse(this.date);
        		}
        		catch (ParseException e)
        		{
        			System.err.println(this.date);
        		}
        	}
        	return new Date();
        }
        
        /**
         * カテゴリ
         */
        public String getCategory()
        {
        	return category; 
        }
        /**
         * 質問者
         */
        public String getAuthor()
        {
        	return author; 
        }
        /**
         * ランク
         */
        public int getRank()
        {
        	return rank;
        }



        // コンストラクタ

        /**
         * コンストラクタ
         * @param url 質問ページのURL
         * @param title タイトル
         * @param description 質問文の一部
         * @param date 投稿日時
         * @param category カテゴリ
         * @param author 質問者
         * @param rank 質問者
         */
        public OshieteGooElement(String url, String title, String description, String date, String category, String author, int rank)
        {
            this.title = title;
            this.url = url;
            this.description = description;
            this.category = category;
            this.date = date;
            this.author = author;
            this.rank = rank;
        }




        // ISearchResultElement メンバ
//
//        /// <summary>
//        /// 質問ページのURL
//        /// </summary>
//        public String getURL()
//        {
//        	return this.URL;
//        }
//
//        /// <summary>
//        /// タイトル
//        /// </summary>
//        public String getTitle()
//        {
//            return this.Title;
//        }
//
//        /// <summary>
//        /// 質問文の一部
//        /// </summary>
//        public String getDescription()
//        {
//            return this.Description; 
//        }



//        //#region ISerializable メンバ
//
//        void System.Runtime.Serialization.ISerializable.GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context)
//        {
//            info.AddValue("url", this.url);
//            info.AddValue("title", this.title);
//            info.AddValue("description", this.description);
//            info.AddValue("date", this.date);
//            info.AddValue("category", this.category);
//            info.AddValue("author", this.author);
//            info.AddValue("rank", this.rank);
//        }
//
//        /// <summary>
//        /// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
//        /// </summary>
//        /// <param name="info"></param>
//        /// <param name="context"></param>
//        protected OshieteGooElement(SerializationInfo info, StreamingContext context)
//        {
//            this.url = info.GetString("url");
//            this.title = info.GetString("title");
//            this.description = info.GetString("description");
//            this.date = info.GetString("date");
//            this.category = info.GetString("category");
//            this.author = info.GetString("author");
//            this.rank = info.GetInt32("rank");
//        }
//
//        //#endregion
//
//        //#region IRankedElement メンバ
//
//        int IRankedElement.Rank
//        {
//            get { return this.Rank; }
//        }


    }

