//﻿using System;
//using System.Collections.Generic;
//using System.Text;
//using System.Runtime.Serialization;

package slothLib.web.search;

import java.util.ArrayList;
import java.util.List;

    /**
     * 教えて！Goo検索が返す検索結果全体
     * <remarks>
     * 

     * <newpara>[2007-06-12][inagawa]作成</newpara>
     * </remarks>
     */
    public class OshieteGooSearchResult implements ISearchResult
    {
        // privateフィールド
        private OshieteGooElement[] resultElements;
        private String query;
        private long searchTotalResults;
        //private List<ISearchResultElement> elementList;


        // プロパティ

        /**
         * 検索結果要素の配列
         */
        public OshieteGooElement[] getResultElements()
        {
            return this.resultElements; 
        }

        /**
         * クエリ
         */
        public String getQuery()
        {
            return this.query;
        }

        /**
         * 検索ヒット数
         */
        public long getSearchTotalResults()
        {
            return this.searchTotalResults; 
        }

        // <summary>
        // 取得した結果要素の数
        // </summary>
        //public int Count
        //{
        //    get { return this.resultElements.length; }
        //}



        // コンストラクタ
        /**
         * コンストラクタ
         * @param query クエリ
         * @param searchTotalResults 検索ヒット数
         * @param resultElements 結果要素の配列
         */
        public OshieteGooSearchResult(String query, long searchTotalResults, OshieteGooElement[] resultElements)
        {
            this.query = query;
            this.searchTotalResults = searchTotalResults;
            this.resultElements = resultElements;
        }



        // その他のメソッド
        /**
         * 概要のリストを返すメソッド
         * @return 
         */
        public List<String> getDescriptionList()
        {
            List<String> sList = new ArrayList<String>();
            for (OshieteGooElement element: resultElements)
            {
                sList.add(element.getDescription());
            }
            return sList;
        }



        // ISearchResult メンバ

//        ISearchResultElement[] ISearchResult.ResultElements
//        {
//            get { return this.ResultElements; }
//        }
//
//        String ISearchResult.Query
//        {
//            get { return this.Query; }
//        }
//
        public long getTotalNumber()
        {
            return this.getSearchTotalResults(); 
        }

        //ISearchResultElement ISearchResult.this[int index]
        //{
        //    get { return this.resultElements[index]; }
        //}

        //int ISearchResult.Count
        //{
        //    get { return this.Count; }
        //}




        // ISerializable メンバ

//        void System.Runtime.Serialization.ISerializable.GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context)
//        {
//            info.AddValue("query", this.query);
//            info.AddValue("searchTotalResults", this.searchTotalResults);
//            info.AddValue("resultElements", this.resultElements);
//        }
//
//        /// <summary>
//        /// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
//        /// </summary>
//        /// <param name="info"></param>
//        /// <param name="context"></param>
//        protected OshieteGooSearchResult(SerializationInfo info, StreamingContext context)
//        {
//            this.query = info.GetString("query");
//            this.searchTotalResults = info.GetInt64("searchTotalResults");
//            this.resultElements = (OshieteGooElement[])info.GetValue("resultElements", typeof(OshieteGooElement[]));
//        }
//
//        //#endregion
    }
