package slothLib.web.search;

/**
 * Yahoo Web 画像が返す検索結果全体。
 * <remarks>
 * 

 * <newpara>[2007-05-24][kondo]作成</newpara>
 * <newpara>[2007-06-23][kondo]修正</newpara>
 * </remarks>
 */
//[Serializable]
public class YahooJpImageSearchResult implements IImageSearchResult
 {
	
	// private フィールド
	
	private YahooJpImageElement[] resultElements;
	private String query;
	
	private long totalResultsAvailable;
	private int totalResultsReturned;
	private int firstResultPosition;
	//private List<ISearchResultElement> elementList;
	


        // コンストラクタ

	/**
	 * コンストラクタ
	 * @param query 検索クエリ
	 * @param totalResultsAvailable データ内のマッチしたクエリ数です。
	 * @param totalResultsReturned 返却され、かつマッチしたクエリの数です。もし有効な結果の合計が少ない場合、要求した結果の数より少ない場合があります。
	 * @param firstResultPosition 全検索結果の最初のポジションです。
	 * @param resultElements 
	 */
	public YahooJpImageSearchResult(String query, long totalResultsAvailable, int totalResultsReturned, int firstResultPosition, YahooJpImageElement[] resultElements)
	{
		this.query = query;
		
		this.totalResultsAvailable = totalResultsAvailable;
		this.totalResultsReturned = totalResultsReturned;
		this.firstResultPosition = firstResultPosition;
		//this.elementList = new List<ISearchResultElement>(resultElements);
		this.resultElements = resultElements;
	}
	

	
	// プロパティ
	
	/**
	 * 検索結果要素の配列
	 */
	public YahooJpImageElement[] getResultElements()
	{
		return this.resultElements;
	}

	/**
	 * 検索に使われたクエリ
	 */
	public String getQuery()
	{
		return this.query;
	}
	
	/**
	 * 検索総件数
	 */
	public long getTotalResultsAvailable()
	{
		return this.totalResultsAvailable;
	}
	
	/**
	 * この検索結果に含まれる検索結果数
	 */
	public int getTotalResultsReturned()
	{
		return this.totalResultsReturned;
	}
	
	/**
	 * 全検索結果の最初のポジション
	 */
	public int getFirstResultPosition()
	{
		return this.firstResultPosition;
	}
	
	///// <summary>
	///// 検索結果の要素の配列
	///// </summary>
	//public YahooJpImageElement[] ResultElements
	//{
	//    get
	//    {
	//        YahooJpImageElement[] result = new YahooJpImageElement[this.elementList.Count];
	//        for (int i = 0; i < this.elementList.Count; i++)
	//        {
	//            result[i] = (YahooJpImageElement)this.elementList[i];
	//        }
	//        return result;
	//    }
	//}
	
	//public int Count
	//{
	//    get
	//    {
	//        return this.elementList.Count;
	//    }
	//}
	

	
	// ISearchResult メンバ
	
	/**
	 * 検索結果要素の配列
	 */
	//ISearchResultElement[] getResultElements()
	//{
	//    return this.getResultElements(); 
	//}
	
	/**
	 * 検索に使われたクエリ
	 */
	//String getQuery()
	//{
	//	return this.Query; 
	//}
	
	/**
	 * 検索総件数
	 */
	public long getTotalNumber()
	{
		return this.totalResultsAvailable;
	}
	
	//ISearchResultElement ISearchResult.this[int index]
	//{
	//    get
	//    {
	//        return this.elementList[index];
	//    }
	//}
	
	//int ISearchResult.Count
	//{
	//    get
	//    {
	//        return this.Count;
	//    }
	//}
	

	
	// IImageSearchResult メンバ
	
	/**
	 * 検索結果要素の配列
	 */
	//IImageElement[] IImageSearchResult.ResultElements
	//{
//		get { return this.ResultElements; }
//	}
	
	//IImageElement IImageSearchResult.this[int index]
	//{
	//    get
	//    {
	//        return (IImageElement)this.elementList[index];
	//    }
	//}
	

	
	// ISerializable メンバ
	
//	/// <summary>
//	/// シリアライズ化するときに呼び出される関数
//	/// </summary>
//	/// <param name="info">逆シリアル化に必要なすべてのデータ</param>
//	/// <param name="context">シリアル化ストリームの転送元と転送先</param>
//	void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
//	{
//		info.AddValue("query", this.query);
//		info.AddValue("totalResultsAvailable", this.totalResultsAvailable);
//		info.AddValue("totalResultsReturned", this.totalResultsReturned);
//		info.AddValue("firstResultPosition", this.firstResultPosition);
//		//info.AddValue("elementList", this.elementList);
//		info.AddValue("resultElements", this.resultElements);
//	}
//	
//	/// <summary>
//	/// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
//	/// </summary>
//	/// <param name="info">シリアル化に必要なすべてのデータ</param>
//	/// <param name="context">シリアル化ストリームの転送元と転送先</param>
//	protected YahooJpImageSearchResult(SerializationInfo info, StreamingContext context)
//	{
//		this.query = info.GetString("query");
//		this.totalResultsAvailable = info.GetInt64("totalResultsAvailable");
//		this.totalResultsReturned = info.GetInt32("totalResultsReturned");
//		this.firstResultPosition = info.GetInt32("firstResultPosition");
//		//this.elementList = (List<ISearchResultElement>)info.GetValue("elementList", typeof(List<ISearchResultElement>));
//		this.resultElements = (YahooJpImageElement[])info.GetValue("resultElements", typeof(YahooJpImageElement[]));
//	}
	

	
 
}
