package smart_gs.image_search.normal.swingui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import smart_gs.logical.GSResource;
import smart_gs.logical.Markup;

public class GSImageSearchResultPanelPopupMenu extends JPopupMenu {
	public GSImageSearchResultPanelPopupMenu(GSResource resource) {
		JMenuItem jumpItem = new JMenuItem("Jump");
		jumpItem.addActionListener(new ResourceJumpActionListener(resource));
		JMenuItem openItem = new JMenuItem("Open");
		openItem.addActionListener(new ResourceOpenActionListener(resource));
		this.add(jumpItem);
		this.add(openItem);
	}
}

class ResourceJumpActionListener implements ActionListener {

	private GSResource resource;

	ResourceJumpActionListener(GSResource resource) {
		super();
		this.resource = resource;
	}
	
	@Override
	public void actionPerformed(ActionEvent arg0) {
		((Markup)this.resource).jump();
	}

}

class ResourceOpenActionListener implements ActionListener {

	private GSResource resource;

	ResourceOpenActionListener(GSResource resource) {
		super();
		this.resource = resource;
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		((Markup)this.resource).openNewWindow();
	}
}
