/* $Id: UsersNote.java 368 2011-09-29 18:36:42Z shayashi $ */
package smart_gs.logical;

import reasoning_web.logical.inter_face.RWElement;
import smart_gs.GSConstants;
import smart_gs.debugprint.Debugprint;
import smart_gs.logical.visitor.Visitor;

public class UsersNote extends SmartDocument{
	
	public static final String USERSNOTE = URICreator.USERS_NOTE;
	private static int pageIndex = 0;
	private int _pageVIewIndex;
	
	private UsersNoteDirectory directory;

	public UsersNote() {
		super();
		this.source = "<xml><html></html></xml>";
		int id = this.hashCode();
		//071212 shimizu wrote;
		this.name = "";
		this.setId(id);
		this._pageVIewIndex = pageIndex++;
		this.setURIs();
	}
	
	public UsersNote(UsersNoteDirectory parentUsersNoteDir, String name,String uri, String originalURI, String version){
		super();
		this.directory = parentUsersNoteDir;

		this.source = "<xml><html></html></xml>";
		this.setName(name);
		int id = this.hashCode();
		//071212 shimizu wrote;
		this.setId(id);
		this._pageVIewIndex = pageIndex++;
		this.setURIs(uri, originalURI);
		this.setVersion(version);
	}

	public UsersNote(UsersNoteDirectory parentUsersNoteDir, String noteName) {
		super();
		this.directory = parentUsersNoteDir;
	
		this.source = "<xml><html></html></xml>";
		this.setName(noteName);
		int id = this.hashCode();
		this.setId(id);
		this._pageVIewIndex = pageIndex++;
		this.setURIs();
	}

	//1028 shimizu wrote;
	public GSResource getTextSegmentByURI(String uri) {
		for(int i=0;i<this.segments.size();i++){
			if(this.segments.get(i).getURI().equals(uri)){
				return this.segments.get(i);
			}
		}
		return null;
	}

	
	@Override
	public String toString() {
		return this.name;
	}

	
	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
	//20080931 hashimoto
	public String getName(){
		return this.name;
	}
	// ADD NorthGrid
	/**
	 * \pCfbNXݒ
	 */
	public void setPageViewIndex(int number){
		_pageVIewIndex = number;
	}
	// ADD NorthGrid
	/**
	 * \pCfbNX擾
	 */
	public int getPageViewIndex(){
		return _pageVIewIndex;
	}
	
	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}

	@Override
	public String getTypeString() {
		return URICreator.USERS_NOTE;
	}

	public Integer getPageIndex() {
		// TODO Auto-generated method stub
		return null;
	}
	
	public UsersNoteDirectory getUsersNoteDirParent() {
		return this.directory;
	}
	
	public String getFolderPath() {
		return this.directory.getPath();
	}

	public void setDirectory(UsersNoteDirectory usersNoteDirectory) {
		this.directory = usersNoteDirectory;
	}

}