/* $Id: DirectorySettingWindow.java 439 2011-10-19 12:50:30Z shayashi $ */
package smart_gs.menu;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import smart_gs.SmartGS;
import smart_gs.logical.Preference;
import smart_gs.menu.action.SetCurrentDirectoryAction;
import smart_gs.menu.action.SetDscFolderPathAction;
import smart_gs.menu.action.SetImageFolderPathAction;
import smart_gs.menu.action.SetRWBackgroundFilePathAction;
import smart_gs.swingui.ButtonFrame;
import smart_gs.util.GSImageFileUtils;
import smart_gs.util.GSPathStringGrammarChecker;

/**
 * etH_̃pXݒ肷EBhE
 * 
 * @author kaszuhiro kobayashi
 * 
 */
@SuppressWarnings("serial")
public class DirectorySettingWindow extends ButtonFrame implements
		ActionListener {

	private JPanel directorySettingPanel;

	private JTextField smart_gsTextField;

	private JPanel gsFolderPanel;
	private JTextField gsTextField;

	private JPanel imageFolderPanel;
	private JTextField imageTextField;	

	private JPanel dscFolderPanel;
	private JTextField dscTextField;	
	
	private JPanel defaultGsFilePanel;
	private JTextField defaultGsFileTextField;

	// 2007/12/8 kazuhiro kobayashi
	private JPanel RWBackgroundFilePanel;
	private JTextField RWBackgroundFileTextField;

	private static DirectorySettingWindow singleton = new DirectorySettingWindow();

	public static DirectorySettingWindow getInstance() {
		return singleton;
	}

	public DirectorySettingWindow() {
		super("Data Directories & Files Setting");

		this.setAlwaysOnTop(true);
		this.setResizable(false);

//		shaysahi 2011.05.25
		if (SmartGS.isDscFolderSetting()) {
			this.directorySettingPanel = new JPanel(new GridLayout(5, 1));
		} else {
			this.directorySettingPanel = new JPanel(new GridLayout(4, 1));
		}
		
		this.gsFolderPanel = new JPanel(new FlowLayout());
		this.gsFolderPanel.setBorder(new TitledBorder("GS Files"));
		this.gsTextField = new JTextField(20);
		this.gsTextField.setText(Preference.getInstance().getGsFolderPathString());
		JButton gsReferenceButton = new JButton("Select ...");
		SetCurrentDirectoryAction gsAction = new SetCurrentDirectoryAction();
		gsReferenceButton.addActionListener(gsAction);
		this.gsFolderPanel.add(gsTextField);
		this.gsFolderPanel.add(gsReferenceButton);

		this.imageFolderPanel = new JPanel(new FlowLayout());
		this.imageFolderPanel.setBorder(new TitledBorder("Images"));
		this.imageTextField = new JTextField(20);
		this.imageTextField.setText(Preference.getInstance()
				.getImageFolderPathString());
		JButton imageReferenceButton = new JButton("Select ...");
		SetImageFolderPathAction imageAction = new SetImageFolderPathAction();
		imageReferenceButton.addActionListener(imageAction);
		this.imageFolderPanel.add(imageTextField);
		this.imageFolderPanel.add(imageReferenceButton);
		
		// This is optional.
		if (SmartGS.isDscFolderSetting()) {
			this.dscFolderPanel = new JPanel(new FlowLayout());
			this.dscFolderPanel.setBorder(new TitledBorder("DSC Folder"));
			this.dscTextField = new JTextField(20);
			this.dscTextField.setText(Preference.getInstance()
					.getDscFolderPathString());
			JButton dscReferenceButton = new JButton("Select ...");
			SetDscFolderPathAction dscAction = new SetDscFolderPathAction();
			dscReferenceButton.addActionListener(dscAction);
			this.dscFolderPanel.add(dscTextField);
			this.dscFolderPanel.add(dscReferenceButton);
		}

		this.defaultGsFilePanel = new JPanel(new FlowLayout());
		this.defaultGsFilePanel.setBorder(new TitledBorder("Default GS File"));
		this.defaultGsFileTextField = new JTextField(20);
		this.defaultGsFileTextField.setText(Preference.getInstance()
				.getDefaultGsFilePathString());
		JButton defaultGsFileReferenceButton = new JButton("Select ...");
		SetDefaultGsFileAction defaultGsFileAction = new SetDefaultGsFileAction();
		defaultGsFileReferenceButton.addActionListener(defaultGsFileAction);
		this.defaultGsFilePanel.add(this.defaultGsFileTextField);
		this.defaultGsFilePanel.add(defaultGsFileReferenceButton);

		this.RWBackgroundFilePanel = new JPanel(new FlowLayout());
		this.RWBackgroundFilePanel.setBorder(new TitledBorder(
				"RW Background File"));
		this.RWBackgroundFileTextField = new JTextField(20);
		this.RWBackgroundFileTextField.setText(Preference.getInstance()
				.getRWBackgroundFilePathString());
		JButton RWBackgroundFileReferenceButton = new JButton("Select ...");
		SetRWBackgroundFilePathAction RWBackgroundFileAction = new SetRWBackgroundFilePathAction();
		RWBackgroundFileReferenceButton
				.addActionListener(RWBackgroundFileAction);
		this.RWBackgroundFilePanel.add(this.RWBackgroundFileTextField);
		this.RWBackgroundFilePanel.add(RWBackgroundFileReferenceButton);

		this.directorySettingPanel.add(this.gsFolderPanel);
		this.directorySettingPanel.add(this.imageFolderPanel);
		if (SmartGS.isDscFolderSetting()) {
			this.directorySettingPanel.add(this.dscFolderPanel);
		}
		this.directorySettingPanel.add(this.defaultGsFilePanel);

		this.directorySettingPanel.add(this.RWBackgroundFilePanel);

		this.getContentPane().add(directorySettingPanel, BorderLayout.CENTER);
		this.pack();

	}

	/**
	 * smart_gsFolderPathݒ肷ƁAnameCorrespondence
	 * ̃tH_̃pXsmart_gsFolderPath̉ɎIɐݒ肷
	 * 
	 * @param path
	 */
	public void setSmart_gsTextField(String path) {
		this.smart_gsTextField.setText(path);
		if (!path.endsWith("/")) path = path + "/";
		this.setGsTextField(path + "gs/");
		this.setImageTextField(path + "images/");
	}

	public void setGsTextField(String path) {
		this.gsTextField.setText(path);
	}

	public void setImageTextField(String path) {
		this.imageTextField.setText(path);
	}
	
	public void setDscTextField(String path) {
		this.dscTextField.setText(path);
	}

	public void setDefaultGsFileField(String path) {
		this.defaultGsFileTextField.setText(path);
	}

	public void setRWBackgroundFileField(String path) {
		this.RWBackgroundFileTextField.setText(path);
	}

	public void ok() {
		boolean gsFilesCondition = false;
		boolean imagesCondtion = false;
		boolean dscCondtion = false;
		boolean defaultGsFileCondition = false;
		boolean rWBackgroundFileCondition = false;
		
		String gsFilesPathString = this.gsTextField.getText();
		String imagesPathString = this.imageTextField.getText();
		if (dscTextField == null) dscTextField =imageTextField;
		String dscPathString = this.dscTextField.getText();
		String defaultGsFilePathString = this.defaultGsFileTextField.getText();
		String rWBackgroundFilePathString = this.RWBackgroundFileTextField.getText();
		
		gsFilesCondition = GSPathStringGrammarChecker.isGsPath(gsFilesPathString);
		imagesCondtion = GSPathStringGrammarChecker.isGsPath(imagesPathString);
		dscCondtion = GSPathStringGrammarChecker.isGsPath(dscPathString);
		defaultGsFileCondition = GSPathStringGrammarChecker.isGsPath(defaultGsFilePathString) || defaultGsFilePathString.equals("");
		rWBackgroundFileCondition = GSPathStringGrammarChecker.isGsPath(rWBackgroundFilePathString);
		
		String errorMessage = "";
		String warningMessage = "";
		
		if (gsFilesCondition == false) {
			errorMessage += "GS Files Path Error: not fit to the GS file path grammar.\n";
		} else {
			if (GSPathStringGrammarChecker.confusingSeparators(gsFilesPathString)) {
				warningMessage += "GS Files Path Warnig: both of \\ and / present.\n";
			}
			if (!GSPathStringGrammarChecker.endsWithSeparator(gsFilesPathString)) {
				warningMessage += "GS Files Path Warnig: it ends not with a separator.\n";
			}
		}
		
		if (imagesCondtion == false) {
			errorMessage += "Images Path Error: not fit to the GS file path grammar.\n";
		} else {
			if (GSPathStringGrammarChecker.confusingSeparators(imagesPathString)) {
				warningMessage += "Images Path Warnig: both of \\ and / present.\n";
			}
			if (!GSPathStringGrammarChecker.endsWithSeparator(imagesPathString)) {
				warningMessage += "Images Path Warnig: it ends not with a separator.\n";
			}
		}
		
		if (dscCondtion == false) {
			errorMessage += "DSC Folder Path Error: not fit to the GS file path grammar.\n";
		} else {
			if (GSPathStringGrammarChecker.confusingSeparators(dscPathString)) {
				warningMessage += "DSC Folder Path Warnig: both of \\ and / present.\n";
			}
			if (!GSPathStringGrammarChecker.endsWithSeparator(dscPathString)) {
				warningMessage += "DSC Folder Path Warnig: it ends not with a separator.\n";
			}
		}
		
		if (defaultGsFileCondition == false) {
			errorMessage += "Default GS File Path Error: not fit to the GS file path grammar.\n";
		} else if (GSPathStringGrammarChecker.confusingSeparators(defaultGsFilePathString)) {
			warningMessage += "Default GS File Path Warnig: both of \\ and / present.\n";
		}
		
		if (!(defaultGsFilePathString.endsWith(".gs")
				|| defaultGsFilePathString.endsWith(".gsx")
				|| defaultGsFilePathString.equals(""))) {
			errorMessage += "Default GS File Name Error: must ends with \".gs\" or \".gsx\".\n";
		}
	
		if (rWBackgroundFileCondition == false) {
			errorMessage += "RW Backgroundfile Path Error: not fit to the GS file path grammar.\n";
		} else if (GSPathStringGrammarChecker.confusingSeparators(rWBackgroundFilePathString)) {
			warningMessage += "RW Backgroundfile Path Warnig: both of \\ and / present.\n";
		}
		
		if (! GSImageFileUtils.isAcceptable(rWBackgroundFilePathString)) {
			errorMessage += "Default GS File Name Error: must ends with one of " 
				+  GSImageFileUtils.getDescription() + ".\n";
		}

		if (!errorMessage.isEmpty()) {
			JOptionPane.showMessageDialog(null,
					errorMessage + warningMessage, "message",
					JOptionPane.INFORMATION_MESSAGE);
			return;
		} else {
			Preference.getInstance().setGsFolderPathString(gsFilesPathString);
			Preference.getInstance().setImageFolderPathString(imagesPathString);
			Preference.getInstance().setDscFolderPathString(dscPathString);
			Preference.getInstance().setDefaultGsFilePath(defaultGsFilePathString);
			Preference.getInstance().setRWBackgroundFilePathString(rWBackgroundFilePathString);
			JOptionPane.showMessageDialog(null,
					"Pathes are set.\n" + "Reboot SMAR-GS to validate path settings.\n" + warningMessage, "message",
					JOptionPane.INFORMATION_MESSAGE);
		};
		this.dispose();
	}

	public void cancel() {
		this.dispose();
	}


	class GsFileNameFormatException extends Exception {
		public GsFileNameFormatException() {
			singleton.setAlwaysOnTop(false);
			JOptionPane
					.showConfirmDialog(null, "GsFile must has extension \".gs or .gsx\"",
							"error", JOptionPane.OK_OPTION,
							JOptionPane.WARNING_MESSAGE);
			singleton.setAlwaysOnTop(true);
		}
	}

	class RWBackgroundNameFormatException extends Exception {
		public RWBackgroundNameFormatException() {
			singleton.setAlwaysOnTop(false);
			JOptionPane.showConfirmDialog(null,
					"RWBackground must be image file", "error",
					JOptionPane.OK_OPTION, JOptionPane.WARNING_MESSAGE);
			singleton.setAlwaysOnTop(true);
		}
	}
}
