/* $Id: ShowLinesActionListener.java 475 2011-12-02 08:46:54Z ohura $ */
package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.debugprint.Debugprint;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;

public class ShowLinesActionListener implements ActionListener {

	private AbstractGSWindow parent;

	public ShowLinesActionListener(AbstractGSWindow parent) {
		this.parent = parent;
	}

	public void actionPerformed(ActionEvent e) {
		ImageLabel.Show mode = this.parent.getSpreadCanvas().imageLabel.getLineSegmentShowingMode();
		this.parent.getSpreadCanvas().imageLabel.stepLineSegmentShowingMode(mode);
		
		Debugprint.message("current show-line mode: " + this.parent.getSpreadCanvas().imageLabel.getLineSegmentShowingMode());
		if(parent instanceof WorkspaceWindow) {
			WorkspaceWindow.getInstance().repaint();
		} else if (parent instanceof GSEditor) {
			parent.repaint();
		}
	}

}
