/* $Id: MarkupInputDialog.java 439 2011-10-19 12:50:30Z shayashi $ */
package sml_editor.swingui;

/*
 * 쐬: 2006/04/23
 *
 */

import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

import smart_gs.swingui.WorkspaceWindow;



/**
 * @author kazuaki kobayashi
 *
 */
public class MarkupInputDialog extends JDialog implements ActionListener{
	
	private JPanel markupContentPane = null;

	private JButton okButton = null;

	private JButton cancelButton = null;

	private JButton deleteButton = null;

	private JComboBox comboBox = null;

	private JLabel titleLabe = null;

	private JLabel iconLabel = null;
	
	private Object[] objects = null;

	private boolean ok = false;

	public MarkupInputDialog(Frame owner, String title,boolean modal,Object[] objects){
		super(owner,title,modal);
		this.objects = objects;
		initialize();
	}

	/**
	 * Return the JFrameContentPane property value.
	 * @return javax.swing.JPanel
	 */
	private JPanel getJFrameContentPane() {
		if (markupContentPane == null) {
			iconLabel = new JLabel(UIManager.getIcon("OptionPane.informationIcon"));
			iconLabel.setBounds(new Rectangle(14, 20, 70, 48));
			titleLabe = new JLabel();
			titleLabe.setBounds(new Rectangle(92, 12, 129, 21));
			titleLabe.setText("Select Tag");
			markupContentPane = new javax.swing.JPanel();
			markupContentPane.setName("JFrameContentPane");
			markupContentPane.setLayout(null);
			markupContentPane.add(getOKButton(), null);
			markupContentPane.add(getCancelButton(), null);
			markupContentPane.add(getComboBox(), null);
			markupContentPane.add(titleLabe, null);
			markupContentPane.add(iconLabel, null);
			markupContentPane.add(getDeleteButton(), null);
		}
		return markupContentPane;
	}

	/**
	 * Initialize the class.
	 */
	private void initialize() {

		this.setName("JFrame1");
		this.setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
		this.setBounds(45, 25, 425, 146);
		this.setTitle("Marking up");
		this.setContentPane(getJFrameContentPane());

	}

	/**
	 * This method initializes okButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getOKButton() {
		if (okButton == null) {
			okButton = new JButton();
			okButton.setText("OK");
			okButton.addActionListener(this);
			okButton.setBounds(new Rectangle(90, 70, 80, 26));
		}
		return okButton;
	}

	/**
	 * This method initializes cancelButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getCancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton();
			cancelButton.setText("Cancel");
			cancelButton.addActionListener(this);
			cancelButton.setBounds(new Rectangle(186, 70, 80, 26));
		}
		return cancelButton;
	}

	/**
	 * This method initializes comboBox	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getComboBox() {
		if (comboBox == null) {
			comboBox = new JComboBox(objects);
			comboBox.setEditable(true);
			comboBox.setBounds(new Rectangle(90, 40, 222, 19));
		}
		return comboBox;
	}

	/**
	 * This method initializes deleteButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getDeleteButton() {
		if (deleteButton == null) {
			deleteButton = new JButton();
			deleteButton.setBounds(new Rectangle(316, 40, 80, 19));
			deleteButton.addActionListener(this);
			deleteButton.setText("DELETE");
		}
		return deleteButton;
	}
	
	public String getSelectComboBox(){
		if(isOk()){
			return (String)comboBox.getSelectedItem();
		}else{
			return null;
		}
	}
	public ArrayList<String> getALLComboBox(){
		ArrayList<String> list = new ArrayList<String>();
		if(comboBox != null){
			for(int i=0;i<comboBox.getItemCount();i++){
				list.add((String)comboBox.getItemAt(i));
			}
		}
		return list;
	}
	
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() != null){
			if(e.getSource() ==  okButton){
				ok = true;
				setVisible(false);
			}else if(e.getSource() ==  cancelButton){
				ok = false;
				setVisible(false);
			}else if(e.getSource() == deleteButton){
				if(comboBox != null){
					comboBox.removeItemAt(comboBox.getSelectedIndex());
//					WorkspaceWindow.setUpdated(true) is not necessary,
//					since the change is made on tags file and so not recorded in gsx file.				
				}
			}
		}
	}

	public boolean isOk() {
		return ok;
	}

	
}

