/* $Id: WebDavSyncChooser.java 125 2011-03-09 09:49:51Z ohura $ */
package webdav;

import javax.swing.SwingUtilities;
import java.awt.BorderLayout;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.JTree;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.GridBagLayout;
import java.awt.Toolkit;

import javax.swing.JScrollPane;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Stack;

import javax.swing.JTable;
import javax.swing.JButton;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

import org.apache.commons.httpclient.protocol.Protocol;

import webdav.table.PropFindSort;
import javax.swing.JTextField;
import javax.swing.JLabel;

public class WebDavSyncChooser extends JDialog {

	private static final long serialVersionUID = 1L;

	private JPanel jContentPane = null;

	private JScrollPane jScrollPane = null;

	private JTable jTable = null;

	private JButton jButton = null;

	private JButton jButton1 = null;

	private JDialog myJDialog;
	
	private String owner;

	protected WebDavProcessor webDavProcessor;  //  @jve:decl-index=0:
    protected WebDavSyncViewTableFactory webDavViewTableFactory;  //  @jve:decl-index=0:

	private Stack stack = null;
	private String startpath = null;
	private boolean error = false;

	/**
	 * This method initializes jScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPane() {
		if (jScrollPane == null) {
			jScrollPane = new JScrollPane();
			jScrollPane.setBounds(new Rectangle(27, 13, 599, 255));
			jScrollPane.setViewportView(getJTable());
		}
		return jScrollPane;
	}

	/**
	 * This method initializes jTable	
	 * 	
	 * @return javax.swing.JTable	
	 */
	private JTable getJTable() {
		if (jTable == null) {
			jTable = new JTable();
			
			PropFindInfo[] propFindInfoChild = null;
			try{
				PropFindInfo[] propFindInfo;
				if(startpath != null){
					propFindInfo = webDavProcessor.getPropFindInfo(startpath, 0);
				}else{
					propFindInfo = webDavProcessor.getPropFindInfo("", 0);
				}
				try{
					propFindInfoChild = webDavProcessor.getPropFindInfo(propFindInfo[0].getPath(), 1);
					propFindInfoChild = new PropFindSort().sort(propFindInfoChild);
					if(stack != null){
						if(stack.size() > 1){
							PropFindInfo[] propFindInfoChildTemp = new PropFindInfo[propFindInfoChild.length + 1];
							{	        					
								PropFindInfo propFindInfoUp = new PropFindInfo();
								propFindInfoUp.setDisplayname("..");
								propFindInfoUp.setDirectory(true);
								propFindInfoChildTemp[0] = propFindInfoUp;
								for(int i=0;i<propFindInfoChild.length;i++){
									propFindInfoChildTemp[i + 1] = propFindInfoChild[i]; 
								}
								propFindInfoChild = propFindInfoChildTemp;
							}
						}
					}
				}catch(Exception ex){
					ex.printStackTrace();
				}
			}catch(Exception e){
				e.printStackTrace();
			}
			webDavViewTableFactory = new WebDavSyncViewTableFactory(propFindInfoChild,Color.WHITE,getJButton());
			webDavViewTableFactory.setWebDavProcessor(webDavProcessor);
			if(stack != null){
				webDavViewTableFactory.setStack(stack);
			}
			jTable = webDavViewTableFactory.getJTable();
		}
		return jTable;
	}

	/**
	 * This method initializes jButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton() {
		if (jButton == null) {
			jButton = new JButton();
			jButton.setBounds(new Rectangle(397, 279, 110, 30));
			jButton.setText("Open");
			jButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					myJDialog.setVisible(false);
					webDavViewTableFactory.sync();
				}
			});
			jButton.setEnabled(false);
		}
		return jButton;
	}

	/**
	 * This method initializes jButton1	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton1() {
		if (jButton1 == null) {
			jButton1 = new JButton();
			jButton1.setBounds(new Rectangle(515, 279, 110, 30));
			jButton1.setText("Cancel");
			jButton1.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					myJDialog.setVisible(false);
				}
			});
		}
		return jButton1;
	}


	/**
	 * This is the default constructor
	 */
	public WebDavSyncChooser(Frame frame,String owner,Stack stack,String startpath) {
		super(frame,true);
		myJDialog = this;
		this.owner = owner;
		this.stack = stack;
		this.startpath = startpath;
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		webDavProcessor = WebDavProcessor.getInstance();
		if(webDavProcessor == null){
        	JOptionPane.showMessageDialog(
					new JFrame() , "It failed in login to WebDAV." , "fatal" ,
					JOptionPane.ERROR_MESSAGE
				);
        	setVisible(false);
        	error = true;
        	return;
		}
		
		this.setSize(659, 354);
		this.setContentPane(getJContentPane());
		this.setTitle("Select synchronize folder");
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(null);
			jContentPane.add(getJScrollPane(), null);
			jContentPane.add(getJButton(), null);
			jContentPane.add(getJButton1(), null);
		}
		return jContentPane;
	}
	protected void processWindowEvent(WindowEvent e) {
	    if (e.getID() == WindowEvent.WINDOW_CLOSING ) {
	        this.setVisible(false);
	    }
	}
    public void setCheckOpenList(ArrayList checkOpenList){
    	if(webDavViewTableFactory != null){
        	webDavViewTableFactory.setCheckOpenList(checkOpenList);
    	}
    }

	public boolean isError() {
		return error;
	}

    
}  //  @jve:decl-index=0:visual-constraint="10,10"


