/*
 * 쐬F 2006/08/25
 */
package jp.ac.hokudai.meme.core_smart_gs.searcher;

import java.util.*;

/**
 * @author hajime
 * <p>ResultRects ̓XRAPagedRect[]ZbgɂȂFoundRect̃XgێIuWFNgłB
 * IDocumentSearcher search \bhɑ΂߂lƂėp܂B</p>
 */
public class ResultRects {
    
    /**
     * 
     */
    protected ArrayList resultList_;
    
    /**
     * 
     */
    public ResultRects(){
        resultList_ = new ArrayList();
    }
    
    /**
     * <p></p>
     * @param frect
     */
    public void addResult(FoundRect frect){
        resultList_.add(frect);
    }
    
    /**
     * <p>̌ʁArankʂɌoꂽ̈PagedRect[]`ŕԂ܂B
     * ʂ́Arank=1 ŏʂłBz̓Y0n܂̂Ƃ̈ႢɒӁB</p>
     * @param rank
     * @return rankʂɌoꂽ̈\PagedRect[]`
     */
    public PagedRect[] getPRects(int rank){
    	if(rank==0){
    		//PRINT("rank1ȏŎw肵ĂˁB");
    		return null;
    	}
    	FoundRect frect=(FoundRect)resultList_.get(rank - 1);
    	return frect.getPRects();
    }
    
    /**
     * <p></p>
     * @param rank
     * @return rankʂFoundRect
     */
    public FoundRect getFoundRect(int rank) {
        return (FoundRect) resultList_.get(rank - 1);
    }
    
    /**
     * <p>̌ʁArankʂɌoꂽ̈̃}b`OXRAԂ܂B
     * }b`OXRA͗ގxi傫قǎĂj
     * ގxiقǎĂj肷̂ŁA
     * ̈ӖɂĂ͕ʓr҂ɊmFKvłB
     * </p>
     * @param rank
     * @return rankʂɌoꂽ̈̃}b`OXRAB
     */
    public double getScore(int rank){
    	if(rank==0){
    		//PRINT("rank1ȏŎw肵ĂˁB");
    		return -1;
    	}
    	FoundRect frect=(FoundRect)resultList_.get(rank-1);
    	return frect.getscore();
    }
    
    /**
     * <p>ʂƂďo͂ꂽ̈̐Ԃ܂B
     * ̌ʁA̗̈悪oꂽ̂Ԃ܂B
     * getsize()̖߂lnł΁AgetscoregetPRects̈Ƃ1`nLłƂƂӖ܂B
     * </p>
     * @return ʂƂďo͂ꂽ̈̐B
     */
    public int getSize(){
    	return resultList_.size();
    }
    
    /**
     * <p></p>
     * @param pageNum
     * @return
     */
    public FoundRect[] getPRectsInPage(int pageNum) {
        ArrayList retList = new ArrayList();
        for (Iterator iter = resultList_.iterator(); iter.hasNext();) {
            FoundRect found = (FoundRect) iter.next();
            if (chkInPage(found.getPRects(), pageNum)) {
                retList.add(found);
            }
        }
        return (FoundRect[]) retList.toArray(new FoundRect[0]);
    }
    
    /**
     * <p></p>
     * @param rects
     * @param pageIndex
     * @return
     */
    protected boolean chkInPage(PagedRect[] rects, int pageIndex){
        boolean flag = false;
        for (int i = 0; i < rects.length; i++) {
            if(rects[i].getPageIndex() == pageIndex) flag = true;
        }
        return flag;
    }

}
