package reasoning_web.logical;

import java.util.List;

import smart_gs.reasoning_web.logical.GS_RWRepository;


/**
 * 
 * @author Administrator
 *
 *  \pɉBLoopɑΉĂȂ
 *  @Change Impactl
 */

public class ERCalculator {

	
	public static final double DUMPING_FACTOR = 0.85;    //can be set between 0 and 1
	
	public ERCalculator() {
	}
	public void calculate(){
		
		List<ResourcePointer> pointers = GS_RWRepository.getInstance().getResourcePointers();
		for(int i=0;i<pointers.size();i++){
			double rank = this.calculateER(pointers.get(i));
//			double rank = pointers.get(i).calculateER();
			pointers.get(i).setElementRank(rank);
		}
		
	}
	public double calculateER(ResourcePointer pointer){
		double rank = 0;
		rank += (1 - ERCalculator.DUMPING_FACTOR);
		List<ResourcePointer> elements = pointer.getBackwardDependentElements();
		double sum = 0.0;
		for(int i=0;i<elements.size();i++){
			int ca = elements.get(i).getNumberOfDependentElements();
			if(ca == 0){   //0ɂȂ͂͂ȂÔ
				System.out.println("unexpected error ca shouldn't be zero ");
				ca = 1;
			}
			sum += (elements.get(i).getElementRank()/(double)ca);
		}
		if(sum == 0.0){
			return pointer.getElementRank();
		}
		rank = ERCalculator.DUMPING_FACTOR*sum;
		return rank;
	}	
}
