package smart_gs.drawing_tool.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MemoPadView extends View{

	protected Rectangle2D rectangle;
	protected String memopadtext = "Test.";

	public String getMemoPadText() {
		return memopadtext; 
	}
	public void setMemoPadText(String memopadtext) {
		this.memopadtext = memopadtext;
	}
	
	public MemoPadView(Rectangle2D rectangle){
		super();
		this.rectangle = rectangle;
		this.defaultColor = Color.yellow;
	}

	public MemoPadView(Rectangle2D rectangle, boolean isProtected){
		this(rectangle);
		this.isProtected = isProtected;
	}
	public MemoPadView(Rectangle2D rectangle,boolean isSelected,boolean isEmphasized, boolean isProtected){
		this(rectangle);
		this.isSelected = isSelected;
		this.isEmphasized = isEmphasized;
		this.isProtected = isProtected;
	}
	@Override
	public boolean contains(Point2D point) {
		return this.rectangle.contains(point);
	}
	
	@Override
	protected void drawShape(Graphics2D g) {
		float x = (float) this.rectangle.getX();
		float y = (float) this.rectangle.getY();
		
		g.fill(this.rectangle);
		g.setColor(Color.black);
		g.drawString(memopadtext, x + 10, y + 10);
	}

	@Override
	public int getType() {
		return View.MEMOPAD;
	}

	@Override
	public void moveBy(Point2D d) {
		double x = this.rectangle.getX();
		double y = this.rectangle.getY();
		double width = this.rectangle.getWidth();
		double height = this.rectangle.getHeight();
		this.rectangle = new Rectangle2D.Double(x+d.getX(),y+d.getY(),width,height);
	}
	
	@Override
	public View enlargedView(double ratio, double gapX, double gapY) {
		double x = this.rectangle.getX();
		double y = this.rectangle.getY();
		double w = this.rectangle.getWidth();
		double h = this.rectangle.getHeight();
		Rectangle2D rect = new Rectangle2D.Double(x*ratio+gapX,y*ratio+gapY,w*ratio,h*ratio);
		return new MemoPadView(rect,this.isSelected,this.isEmphasized, this.isProtected);
	}
	public Rectangle2D getRectangle2D() {
		return this.rectangle;
	}
	@Override
	public String getTypeString() {
		return "memopad";
	}
	@Override
	public void drawLinkedShape(Graphics2D g) {
		System.out.println("memopad: drawLinkedShape"); // debug
		if(this.isSelected){
			this.draw(g);
			return;
		};
		Color oldColor = g.getColor();
		Stroke oldStroke = g.getStroke();
		g.setColor(Color.BLUE);
		g.setStroke(new BasicStroke(5));
		this.drawShape(g);
		g.setColor(oldColor);
		g.setStroke(oldStroke);
	}
	@Override
	public Element createXMLElement(Document document) {
		Element element = document.createElement("view");
		element.setAttribute("type","memopad");
		element.setAttribute("x",this.rectangle.getX()+"");
		element.setAttribute("y",this.rectangle.getY()+"");	
		element.setAttribute("width",this.rectangle.getWidth()+"");
		element.setAttribute("height",this.rectangle.getHeight()+"");
		return element;
	}
	public static View restore(Element elem) {
		double x = new Double(elem.getAttribute("x"));
		double y = new Double(elem.getAttribute("y"));
		double width = new Double(elem.getAttribute("width"));
		double height = new Double(elem.getAttribute("height"));
		//kazuhiro kobayashi 10/9
		boolean isProtected = elem.getAttribute("protection").equals("PROTECTED");
		return new MemoPadView(new Rectangle2D.Double(x,y,width,height), isProtected);
	}
	public void setRectangle(Rectangle rectangle) {
		this.rectangle = rectangle;
	}

	
}
