package smart_gs.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

import smart_gs.dictionary.DictionaryDialog;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.CurrentTextSearchActionListener;
import smart_gs.swingui.toolbar.action.ImageSearchActionListener;
import smart_gs.swingui.toolbar.action.Text2ImageActionListener;
import smart_gs.swingui.toolbar.action.TextSearchActionListener;

public class SearchMenu extends JMenu {
	
	public SearchMenu(String title, AbstractGSWindow parent){
		super(title);
		JMenuItem imageSearch = new JMenuItem("Image Search");
		imageSearch.addActionListener(new ImageSearchActionListener(parent));
		imageSearch.setAccelerator(KeyStroke.getKeyStroke("ctrl F"));
		this.add(imageSearch);

		JMenuItem text2Image = new JMenuItem("Text-Image");
		text2Image.addActionListener(new Text2ImageActionListener());
//		this.add(text2Image);
		JMenuItem textSearch = new JMenuItem("Global Text Search");
		textSearch.addActionListener(new TextSearchActionListener());
		this.add(textSearch);
	
		JMenuItem ctextSearch = new JMenuItem("Text Search");
		ctextSearch.setAccelerator(KeyStroke.getKeyStroke("ctrl T"));
		ctextSearch.addActionListener(new CurrentTextSearchActionListener());
		this.add(ctextSearch);
	}

}
