package smart_gs.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import smart_gs.logical.Note;
import smart_gs.logical.NoteTree;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.swingui.toolbar.action.ShowSpreadAction;

@SuppressWarnings("serial")
public class NoteTreePanel extends JPanel implements MouseListener {
	
	private NoteTree tree;
	
	
	public NoteTreePanel(){
		this.setLayout(new BorderLayout());
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.getVerticalScrollBar().setUnitIncrement(20);
		this.tree = NoteTree.getInstance();
		scrollPane.addMouseListener(this);
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		JPanel tree_panel = new JPanel();
		tree_panel.setLayout(new FlowLayout(FlowLayout.LEFT));
		tree_panel.setBackground(Color.white);
		tree_panel.add(tree);
		tree_panel.setBorder(BorderFactory.createLineBorder(Color.BLACK,2));
		tree.addMouseListener(this);
		
		JPanel button_panel = new JPanel();
		JButton show = new JButton("Show");
		show.addActionListener(new ShowSpreadAction());
        button_panel.add(show);
        
        panel.add(tree_panel,BorderLayout.CENTER);

		scrollPane.setViewportView(panel);
		this.add(scrollPane,BorderLayout.CENTER);
		this.add(button_panel,BorderLayout.SOUTH);
	}

	public void mouseClicked(MouseEvent e) {
		if(e.getClickCount() == 2){
			Note note = this.tree.getSelectedNote();
			if(note == null){
				return;
			}
			List<Region> regions = note.getRegions();
			Region region = note.getRegions().get(0);
			region.getView().setIsEmphasized(true);
			Spread spread = region.getSpread();
			for(int i=1;i<regions.size();i++){
				if(regions.get(i).getSpread().equals(spread)){
					regions.get(i).getView().setIsEmphasized(true);
				}
			}
			
			WorkspaceWindow.getInstance().setSpread(spread);
			
		}
	}
	public void mouseEntered(MouseEvent arg0) {
	}

	public void mouseExited(MouseEvent arg0) {
	}

	public void mousePressed(MouseEvent arg0) {
	}

	public void mouseReleased(MouseEvent arg0) {
	}
}
