package smart_gs.swingui.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.tree.TreePath;

import smart_gs.logical.Spread;
import smart_gs.logical.SpreadTree;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;

@SuppressWarnings("serial")
public class MoveTreeToolBar extends JToolBar implements ActionListener{
	protected JButton prev;
	protected JButton next;
	
	protected int historycounter = 0;
	protected int pathCount = 0;
	public MoveTreeToolBar() {
		prev = new JButton("");
		prev.setEnabled(false);
		prev.addActionListener(this);
		prev.setActionCommand("prev");
		this.add(prev);
		next = new JButton("");
		next.setEnabled(false);
		next.addActionListener(this);
		next.setActionCommand("next");
		this.add(next);
	}

	public void actionPerformed(ActionEvent e) {
		if(e.getActionCommand().equals("next")){
			Spread spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount + 1);
			if(spread != null){
				WorkspaceWindow.getInstance().setSpread(spread);
				WorkspaceWindow.getInstance().setImageSearch(spread.toString());
			}
		}else if(e.getActionCommand().equals("prev")){
			Spread spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount - 1);
			if(spread != null){
				WorkspaceWindow.getInstance().setSpread(spread);
				WorkspaceWindow.getInstance().setImageSearch(spread.toString());
			}
		}
	}
	public void setPathCount(int pathCount){
		this.pathCount = pathCount;
		{
			Spread spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount + 1);
			if(spread != null){
				next.setEnabled(true);
			}else{
				next.setEnabled(false);
			}
		}
		{
			Spread spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount - 1);
			if(spread != null){
				prev.setEnabled(true);
			}else{
				prev.setEnabled(false);
			}
		}
	}
}
