package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import smart_gs.logical.Spread;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.util.SegmentInfoCreator;

public class CreateSegmentInfoAction implements ActionListener {
	
	private AbstractGSWindow gsWindow;
	private Spread spread;
	public CreateSegmentInfoAction(AbstractGSWindow gsWindow){
		this.gsWindow = gsWindow;
	}
	public CreateSegmentInfoAction(Spread spread){
		this.spread = spread;
	}
	public void execute(){
		String folderPath = Spread.DSC_FOLDER_PATH+spread.getVolume().getPath();
		String filename = spread.getFileNameWithoutExtension();
		new SegmentInfoCreator(spread).createAllFile(folderPath, filename);
	}
	public void createLineFile(){
		String folderPath = Spread.DSC_FOLDER_PATH+spread.getVolume().getPath();
		String filename = spread.getFileNameWithoutExtension();
		new SegmentInfoCreator(spread).createSegmentInfo(spread.getLines(),folderPath, filename);
	}
	public void actionPerformed(ActionEvent e) {
		this.spread = this.gsWindow.getSpread();
		this.execute();
	}

}
