package sml_editor.swingui.toolbar;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

import smart_gs.swingui.toolbar.action.CurrentTextSearchActionListener;
import sml_editor.swingui.EditorTextPane;
import sml_editor.swingui.toolbar.action.CopyAction;
import sml_editor.swingui.toolbar.action.CutAction;
import sml_editor.swingui.toolbar.action.MarkupAction;
import sml_editor.swingui.toolbar.action.PasteAction;
import sml_editor.swingui.toolbar.action.RedoAction;
import sml_editor.swingui.toolbar.action.RemoveTagAction;
import sml_editor.swingui.toolbar.action.UndoAction;


@SuppressWarnings("serial")
public class EditorToolBar extends JToolBar{
	
	public final static  int EDIT_MODE_BROWSE = 0;
	public final static int EDIT_MODE_SOURCE = 1;
	public final static int EDIT_MODE_EDIT = 2;

	public  int edit_mode = EDIT_MODE_EDIT;

	protected EditorTextPane  textPane;

	protected CopyAction copyAction;
	protected CutAction cutAction;
	protected PasteAction pasteAction;
	protected MarkupAction markupAction;
	protected UndoAction undoAction;
	protected RedoAction redoAction;
	protected RemoveTagAction removeTagAction;
	protected CurrentTextSearchActionListener currentTextSearchAction;
	
	protected JButton copy;
	protected JButton cut;
	protected JButton paste;
	protected JButton markup;
	protected JButton removeTag;
	protected JButton undo;
	protected JButton redo;
	protected JButton search;

	protected JToggleButton source;
	protected JToggleButton browse;
	protected JToggleButton edit;
	protected EditorToolBarPlan toolBarPlan;
	public EditorToolBar(EditorTextPane textPane){
		this(textPane,new EditorToolBarPlan());
	}
	
	public EditorToolBar(EditorTextPane textPane,final EditorToolBarPlan toolBarPlan){
		// ADD NorthGrid EditorToolBarPlanɂăc[o[̍쐬ύXł悤ɏC
		this.toolBarPlan = toolBarPlan;
		this.textPane = textPane;
		copyAction = new CopyAction();
		cutAction = new CutAction();
		pasteAction = new PasteAction();
		markupAction = new MarkupAction();
		undoAction = new UndoAction();
		redoAction = new RedoAction();
		removeTagAction = new RemoveTagAction();
		currentTextSearchAction = new CurrentTextSearchActionListener();
		
		copy = new JButton(new ImageIcon("./icons/copy.gif"));
		copy.addActionListener(copyAction);
		copy.setFocusable(false);
		if(toolBarPlan.isCopy()){
			this.add(copy);
		}
		cut = new JButton(new ImageIcon("./icons/cut.gif"));
		cut.addActionListener(cutAction);
		cut.setFocusable(false);
		if(toolBarPlan.isCut()){
			this.add(cut);
		}
		paste = new JButton("Paste");
		paste.addActionListener(pasteAction);
		paste.setFocusable(false);
		if(toolBarPlan.isPaste()){
			this.add(paste);
		}
		this.markup = new JButton("Mark up");
		this.markup.addActionListener(markupAction);
		this.markup.setFocusable(false);
		if(toolBarPlan.isMarkup()){
			this.add(this.markup);
		}
		undo = new JButton(new ImageIcon("./icons/undo.gif"));
		undo.addActionListener(undoAction);
		if(toolBarPlan.isUndo()){
			this.add(undo);
		}
		redo = new JButton(new ImageIcon("./icons/redo.gif"));
		redo.addActionListener(redoAction);
		if(toolBarPlan.isRedo()){
			this.add(redo);
		}
		this.removeTag = new JButton("Remove tag");
		this.removeTag.addActionListener(removeTagAction);
		
		this.search = new JButton("Text Search");
		this.search.addActionListener(currentTextSearchAction);
		if(toolBarPlan.isSearch()){
			this.add(search);
		}
		
		this.source = new JToggleButton("Source");
		this.browse = new JToggleButton("Browse");
		this.edit = new JToggleButton("Edit");
		//20080622 shimizu wrote
		//this.add(this.removeTag);
		check(this.textPane);
		copyAction.setEditorTextPane(this.textPane);
		cutAction.setEditorTextPane(this.textPane);
		pasteAction.setEditorTextPane(this.textPane);
		markupAction.setEditorTextPane(this.textPane);
		undoAction.setEditorTextPane(this.textPane);
		redoAction.setEditorTextPane(this.textPane);
		removeTagAction.setEditorTextPane(this.textPane);
	}
	public void setTextPane(EditorTextPane textPane){
		this.textPane = textPane;
		check(this.textPane);
		copyAction.setEditorTextPane(this.textPane);
		cutAction.setEditorTextPane(this.textPane);
		pasteAction.setEditorTextPane(this.textPane);
		markupAction.setEditorTextPane(this.textPane);
		undoAction.setEditorTextPane(this.textPane);
		redoAction.setEditorTextPane(this.textPane);
		removeTagAction.setEditorTextPane(this.textPane);
	}
	
	public EditorTextPane getEditorTextPane(){
		return textPane;
	}
	
	
	public void check(EditorTextPane textPane){
		if(textPane == null){
			copy.setEnabled(false);
			cut.setEnabled(false);
			paste.setEnabled(false);
			markup.setEnabled(false);
			removeTag.setEnabled(false);
			undo.setEnabled(false);
			redo.setEnabled(false);
			
			source.setEnabled(false);
			browse.setEnabled(false);
			edit.setEnabled(false);
			search.setEnabled(false);
		}else{
			copy.setEnabled(true);
			cut.setEnabled(true);
			paste.setEnabled(true);
			markup.setEnabled(true);
			removeTag.setEnabled(true);
			undo.setEnabled(true);
			redo.setEnabled(true);
			search.setEnabled(true);

			source.setEnabled(true);
			browse.setEnabled(true);
			edit.setEnabled(true);

			if(source.isSelected() == false && browse.isSelected() == false && edit.isSelected() == false){
				if(toolBarPlan.isEdit()){
					edit.setSelected(true);
				}else if(toolBarPlan.isBrowse()){
					browse.setSelected(true);
				}else if(toolBarPlan.isSource()){
					source.setSelected(true);
				}
			}
		}
	}
}
