/*
 * 쐬F 2006/10/30
 */
package jp.ac.hokudai.meme.core_smart_gs.searcher;

public abstract class AbstractDTWCalculator {

    protected double[][] distTable;

    protected double min(double d1, double d2, double d3) {
        return Math.min(d1, Math.min(d2, d3));
    }
    
    protected void initDTWArray(double[][] dtwArray, int startIndex){
        dtwArray[0][0] = getDist(startIndex, 0);
        for (int i = 1; i < dtwArray.length; i++) {
            dtwArray[i][0] = dtwArray[i - 1][0] + getDist(startIndex, i);
        }
        for (int i = 1; i < dtwArray[0].length; i++) {
            dtwArray[0][i] = dtwArray[0][i - 1] + getDist(startIndex + i, 0);
        }
    }

    protected double calcDist(double[] feat1, double[] feat2) {
        //euclid dist
        double d = 0;
        for (int i = 0; i < feat1.length; i++) {
            d += Math.pow((feat2[i] - feat1[i]), 2);
        }
        return d;
    }
    
    protected void makeDistTable(double[][] fullText, double[][] pattern) {
        int textLength = fullText.length;
        int patLength = pattern.length;
        distTable = new double[patLength][textLength];
        for (int i = 0; i < patLength; i++) {
            for (int j = 0; j < textLength; j++) {
                distTable[i][j] = calcDist(pattern[i], fullText[j]);
            }
        }
    }
    
    protected double getDist(int textIndex, int patIndex) {
        return distTable[patIndex][textIndex];
    }
    
    abstract DistanceAndIndex calcDTWDist(int startIndex, int endIndex, double[][] pattern, double[][] dtwArray);
//    abstract DistanceAndIndex calcDTWDist(double[][] text, double[][] pattern, int startIndex, double[][] dtwArray);
    
}