package jp.ac.hokudai.meme.core_smart_gs.test;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

/**
 * `IsTv.
 * @author Asan
 */
public class RectSelector extends Canvas implements PaintListener, MouseListener, MouseMoveListener {
    Shell shell;
    Color red = new Color(Display.getCurrent(), 255, 0, 0);
    Color white = new Color(Display.getCurrent(), 255, 255, 255);
    int x1, y1, x2, y2;
    
    RectSelector(Shell shell) {
        super(shell, SWT.NONE);
        this.shell = shell;
        addPaintListener(this);
        addMouseListener(this);
        addMouseMoveListener(this);
        setCursor(new Cursor(Display.getCurrent(), SWT.CURSOR_CROSS));
    }

    public void paintControl(PaintEvent e){
        // Ƃ肠Aȉ~\
        GC gc = e.gc;
        gc.setBackground(red);
        gc.fillOval(100, 100, 300, 200);
    }
    
    public void mouseDown(MouseEvent e) {
        if (e.button == 1) {    // {^ꂽƂ
            x1 = x2 = e.x;
            y1 = y2 = e.y;
            setCapture(true);
        }
    }
    
    public void mouseUp(MouseEvent e) {
        if (e.button == 1) {
            x2 = e.x;
            y2 = e.y;
            setCapture(false);
            // ̈bZ[W{bNXŕ\B
            MessageBox msg = new MessageBox(shell);
            msg.setText("`I");
            msg.setMessage("Ï("+x1+","+y1+") ("+x2+","+y2+")");
            msg.open();
            
            // Ⴆ΁Ä̗hԂƂA
            // ̗̈ɕ`悳Ă}`IƂA
            // ̈Ȃ́AȏʂɎg܂B

            redraw();   // ĕ`
        }
    }
    
    public void mouseMove(MouseEvent e) {
        if( (e.stateMask & SWT.BUTTON1) != 0) {
            GC gc = new GC(this);
            gc.setXORMode(true);
            gc.setForeground(white);
            gc.drawRectangle(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x2-x1), Math.abs(y2-y1)); //hide
            x2 = e.x;
            y2 = e.y;
            gc.drawRectangle(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x2-x1), Math.abs(y2-y1)); //hide
            String msg = "("+x1+","+y1+")-("+x2+","+y2+")";
            gc.drawString(msg, x1, y1);
            gc.dispose();
        }
    }   
    
    public void mouseDoubleClick(MouseEvent e) {
        //  E_uNbNꍇAňւȏԂɊׂĂAlɖ߂܂B(S)
        if (e.button == 3) {
            setCapture(false);
            redraw();
        }
    }   
    /**
     * `IsTv𓮂߂̃CEBhEB
     * ʏ́A͕ʃNXɂȂA炪CɂȂB
     */
    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("`I");
        shell.setLayout(new GridLayout());
        
        RectSelector canvas = new RectSelector(shell);
        canvas.setLayoutData(new GridData(GridData.FILL_BOTH)); 
        
        shell.setSize(640, 480);
        shell.open();
        
        while (! shell.isDisposed()) {
            display.readAndDispatch();
            display.sleep();
        }
        display.dispose();
    }
}

