package smart_gs.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JMenu;
import javax.swing.KeyStroke;


import smart_gs.reasoning_web.swingui.ReasoningWebFrame;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.toolbar.SetAttributeAction;

public class ReasoningWebMenu extends JMenu implements ActionListener{

	public ReasoningWebMenu(String title, AbstractGSWindow parent){
		super(title);
		JMenuItem rw = new JMenuItem("Open reasoning web");
		rw.setAccelerator(KeyStroke.getKeyStroke("ctrl R"));
		rw.addActionListener(this);
		
		JMenuItem setAttribute = new JMenuItem("set attribute", new ImageIcon("./icons/attribute.gif"));
		setAttribute.addActionListener(new SetAttributeAction(parent));
		this.add(rw);
		//20080622 shimizu wrote;
		//this.add(setAttribute);
	}
	public void actionPerformed(ActionEvent e) {
		ReasoningWebFrame.getInstance().setVisible(true);
	}
}
