package smart_gs.reasoning_web.desktop.logical;

import java.util.ArrayList;
import java.util.List;

import smart_gs.logical.SmartDocument;
import smart_gs.logical.StandardTextDocument;
import smart_gs.reasoning_web.desktop.swingui.Observable;
import smart_gs.reasoning_web.desktop.swingui.view.DesktopElementView;
import smart_gs.reasoning_web.logical.GS_RWElement;

public abstract class DesktopElement implements GS_RWElement{
	
	
	protected DesktopElementView view;
	protected List<Observable> panels;
	
	protected String name = "default";
	
	protected StandardTextDocument memo;
	protected DeskTopFolder parent = null;
	
	protected DesktopElement(){
		this.view = this.createView();
		this.panels = new ArrayList<Observable>();
		this.memo = new StandardTextDocument();
		
	}
	public DesktopElement(DeskTopFolder parent,String name,String source) {
		this();
		this.memo.setSource(source);
		this.parent = parent;
		this.name = name;
	}
	public DesktopElement(DeskTopFolder parent,String name,StandardTextDocument memo) {
		this.parent = parent;
		this.view = this.createView();
		this.name = name;
		this.panels = new ArrayList<Observable>();
		this.memo = memo;
		this.setName(this.name);
	}
	
	public void addObserver(Observable observer){
		this.panels.add(observer);
	}
	public String getName(){
		return this.name;
	}
	public void setString(String source){
		this.memo.setSource(source);
	}
	public String getSource(){
		return this.memo.getSource();
	}
	public SmartDocument getMemo(){
		return this.memo;
	}
	public void setName(String name){
		this.name = name;
		view.setName(name);
	}
	protected void notifyChange(){
		for(int i=0;i<panels.size();i++){
			this.panels.get(i).notifyChange();
		}
	}
	public abstract void open();
	
	public abstract DesktopElementView createView();
	
	public DeskTopFolder getParent() {
		return this.parent;
	}
	public DesktopElementView getView(){
		return this.view;
	}
	public void setParent(DeskTopFolder parent) {
		this.parent = parent;
	}
	@Override
	public String toString() {
		return this.name;
	}
	protected void setMemo(StandardTextDocument memo) {
		this.memo = memo;
	}
}
