package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import smart_gs.logical.GSResource;
import smart_gs.logical.Region;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.swingui.AbstractGSWindow;

public class ShowLocalViewAction implements ActionListener {
	
	private AbstractGSWindow parent;
	private GSResource resource;
	public ShowLocalViewAction(AbstractGSWindow parent){
		this.parent = parent;
	}
	public ShowLocalViewAction(GSResource resource){
		this.resource = resource;
	}
	public void execute(){
		if(resource == null){
			return;
		}
		if(GS_RWRepository.getInstance().hasLink(resource)){
			GS_RWRepository.getInstance().showLocalView(resource);
		}	
	}
	public void actionPerformed(ActionEvent e) {
		List<Region> regions = this.parent.getSpread().getSelectedRegions();
		
		if(regions.size() == 0){
			// resourceI
			return;
		}
		 
		for(int i=0;i<regions.size();i++){
			if(GS_RWRepository.getInstance().hasLink(regions.get(i))){
				GS_RWRepository.getInstance().showLocalView(regions.get(i));
			}	
		}
	}
	
	
}
