package smart_gs.text_search.swingui;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.StyleContext;
import smart_gs.text_search.logical.TextSearchConstants;
import smart_gs.logical.Spread;
import smart_gs.text_search.SearchTextAction;
import smart_gs.text_search.logical.SearchResult;
import javax.swing.JCheckBox;
import java.awt.event.*;


import smart_gs.spread_selection.SetScopePanel;


@SuppressWarnings("serial")

public class TextSearchDialog extends JDialog  {
	//͈͂̎w
	private SetScopePanel scopePanel;
	
	private JRadioButton allType;
	private JRadioButton transcription;
	//20080901. Texť̂߂̃WI{^ݒu
	private JRadioButton text;
	private JRadioButton annotation;
	private JRadioButton translation;
    private JTextField queryTextPane;
    private JCheckBox caseSensitiveBox;
    private String queryText = null;
    
    private static boolean allTypeSelected = true;
    private static boolean transcriptionSelected;
    private static boolean textSelected;
    private static boolean annotationSelected;
    private static boolean translationSelected;
    private static String queryTextPaneText;
    private static boolean caseSensitiveBoxSelected;
    
	public TextSearchDialog(){
		super(new JFrame(),"Search Dialog");
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());
		this.add(mainPanel, BorderLayout.CENTER);
		
		JPanel queryTextPanel = new JPanel();
		queryTextPanel.setLayout(new BorderLayout());
		queryTextPanel.setBorder(new TitledBorder("query text:"));
		
		this.queryTextPane = new JTextField();
		this.queryTextPane.setFont(new Font(StyleContext.DEFAULT_STYLE,Font.PLAIN,20));
		this.queryTextPane.setText(queryTextPaneText);
		queryTextPanel.add(queryTextPane,BorderLayout.CENTER);
		
		caseSensitiveBox = new JCheckBox("Case sensitive");
		queryTextPanel.add(caseSensitiveBox, BorderLayout.SOUTH);
		
		mainPanel.add(queryTextPanel, BorderLayout.NORTH);
		
		JPanel optionPanel = new JPanel(new GridLayout(1,2));
		mainPanel.add(optionPanel, BorderLayout.CENTER);
		
		
		/*
		 * ͈͂̎wSetScopePanelɈڂ
		 */
		this.scopePanel = new SetScopePanel();

		optionPanel.add(scopePanel);				
		
		JPanel documentTypePanel = new JPanel(new GridLayout(4,1));
		documentTypePanel.setBorder(new TitledBorder("document type"));
		this.text = new JRadioButton("Text");
		this.text.setSelected(textSelected);
		this.transcription = new JRadioButton("Transcription");
		this.transcription.setSelected(transcriptionSelected);
		this.annotation = new JRadioButton("Annotation");
		this.annotation.setSelected(annotationSelected);
		this.translation = new JRadioButton("Translation");
		this.translation.setSelected(translationSelected);
		this.allType = new JRadioButton("All Document Types");
		this.allType.setSelected(allTypeSelected);
		this.caseSensitiveBox.setSelected(caseSensitiveBoxSelected);
		ButtonGroup group2 = new ButtonGroup();
		
		group2.add(transcription);
		group2.add(annotation);
		group2.add(translation);
		group2.add(text);
		group2.add(allType);
		
		transcription.addActionListener(new DocumentTypeSelectAction());
		annotation.addActionListener(new DocumentTypeSelectAction());
		translation.addActionListener(new DocumentTypeSelectAction());
		text.addActionListener(new DocumentTypeSelectAction());
		allType.addActionListener(new DocumentTypeSelectAction());
		
		documentTypePanel.add(transcription);
		documentTypePanel.add(annotation);
		documentTypePanel.add(translation);
		documentTypePanel.add(text);
		documentTypePanel.add(allType);
		optionPanel.add(documentTypePanel);
		
		JPanel buttonPanel = new JPanel();
		JButton ok = new JButton("Search");
		ok.addActionListener(new OKAction());
		buttonPanel.add(ok);
		
		JButton cancel = new JButton("Cancel");
		cancel.addActionListener(new CancelAction());
		buttonPanel.add(cancel);
		
		this.getContentPane().add(mainPanel,BorderLayout.CENTER);
		this.getContentPane().add(buttonPanel,BorderLayout.SOUTH);
		this.setLocationRelativeTo(null);
		this.pack();
	}
	private class OKAction implements ActionListener{
		int documentType;
		public void actionPerformed(ActionEvent e){
			queryText = queryTextPane.getText();
			if(queryText.equals("")){
				JOptionPane.showMessageDialog(null, "type any text");				
			}else{
				queryTextPaneText = queryText;
				transcriptionSelected = transcription.isSelected();
				translationSelected = translation.isSelected();
				annotationSelected = annotation.isSelected();
				allTypeSelected = allType.isSelected();
				textSelected = text.isSelected();
				caseSensitiveBoxSelected = caseSensitiveBox.isSelected();
				
				if(transcription.isSelected()) {
					documentType = TextSearchConstants.TRANSCRIPTION;
				}else if(translation.isSelected()){
					documentType =TextSearchConstants.TRANSLATION;
				}else if(annotation.isSelected()){
					documentType = TextSearchConstants.ANNOTATION;
				}else if(allType.isSelected()){
					documentType = TextSearchConstants.ALLDOCUMENT;
				}else if(text.isSelected()){
					documentType = TextSearchConstants.TEXT;
				}
				search(queryText,documentType,caseSensitiveBox.isSelected());
			}	
		}
	}
	private class DocumentTypeSelectAction implements ActionListener{
		public void actionPerformed(ActionEvent e){
			if(text.isSelected()){
				scopePanel.setEnabled(false);
			}else {
				scopePanel.setEnabled(true);
			}
		}
	}

	private class CancelAction implements ActionListener{
		public void actionPerformed(ActionEvent e) {
			System.out.println("canceled");
			dispose();
		}
	}

	private void search(String queryText, int documentType,boolean isCaseSensitive){
//		List<Spread> spreads = this.getSpreadsToSearch();
		List<Spread> spreads = this.scopePanel.getSpreadsToSearch();
		ArrayList<Spread> spreadsToSearch = new ArrayList<Spread>();
		for(int i=0;i<spreads.size();i++){
			spreadsToSearch.add(spreads.get(i));
		}		
		SearchTextAction searchAction = new SearchTextAction(queryText,spreadsToSearch,documentType,isCaseSensitive);
		searchAction.execute();
		ArrayList<SearchResult> results = (ArrayList<SearchResult>)searchAction.getResults();
		new SearchResultViewer(queryText,results).setVisible(true);				
		dispose();
	}
	
	public void actionPerformed(ActionEvent e) {
		
	}

}
